/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.pocketstorage.inventory;

import com.flanks255.pocketstorage.inventory.PSUSlot;
import com.flanks255.pocketstorage.inventory.StorageManager;
import com.flanks255.pocketstorage.items.PSUTier;
import com.flanks255.pocketstorage.items.PocketStorageUnit;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;

public class PSUItemHandler
implements IItemHandler,
INBTSerializable<CompoundTag> {
    private NonNullList<PSUSlot> slots;
    private int slotCount;
    private int slotCapacity;

    public PSUItemHandler(PSUTier tier) {
        this.slotCount = tier.slots;
        this.slotCapacity = tier.capacity;
        this.slots = NonNullList.withSize((int)tier.slots, (Object)PSUSlot.EMPTY);
    }

    void checkIndex(int slot) {
        if (slot < 0 || slot >= this.slots.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.slots.size() + ")");
        }
    }

    public int getSlots() {
        return this.slotCount;
    }

    public int getSlotLimit(int slot) {
        return this.slotCapacity;
    }

    public PSUSlot getSlot(int slot) {
        this.checkIndex(slot);
        return (PSUSlot)this.slots.get(slot);
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.checkIndex(slot);
        if (!((PSUSlot)this.slots.get(slot)).isEmpty() && ((PSUSlot)this.slots.get(slot)).getCount() > 0) {
            ItemStack tmp = ((PSUSlot)this.slots.get(slot)).getStack();
            tmp.setCount(((PSUSlot)this.slots.get(slot)).getCount());
            return tmp;
        }
        return ItemStack.EMPTY;
    }

    public boolean hasItem(ItemStack stack) {
        for (PSUSlot slot : this.slots) {
            if (slot.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)slot.getStack(), (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    public void upgrade(PSUTier tier) {
        if (tier.slots <= this.slots.size()) {
            return;
        }
        NonNullList<PSUSlot> oldStacks = this.slots;
        this.slots = NonNullList.withSize((int)tier.slots, (Object)PSUSlot.EMPTY);
        for (int i = 0; i < oldStacks.size(); ++i) {
            this.slots.set(i, (Object)((PSUSlot)oldStacks.get(i)));
        }
        this.slotCount = tier.slots;
        this.slotCapacity = tier.capacity;
    }

    public List<PSUSlot> getMatchingSlots(@Nonnull ItemStack stack) {
        return this.slots.stream().filter(s -> ItemStack.isSameItemSameComponents((ItemStack)s.getStack(), (ItemStack)stack)).toList();
    }

    public ItemStack insertItemSlotless(@Nonnull ItemStack stack, boolean allowEmpty, boolean allowVoid) {
        if (stack.isEmpty() || !this.isItemValid(0, stack)) {
            return stack;
        }
        boolean foundAny = false;
        int count = stack.getCount();
        for (PSUSlot slot : this.slots) {
            if (slot.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)slot.getStack(), (ItemStack)stack)) continue;
            foundAny = true;
            int remainder = allowVoid ? 0 : Math.max(slot.getCount() + stack.getCount() - this.slotCapacity, 0);
            slot.setCount(Math.min(slot.getCount() + stack.getCount(), this.slotCapacity));
            this.onContentsChanged();
            ItemStack returnStack = stack.copy();
            returnStack.setCount(remainder);
            return returnStack;
        }
        if (allowEmpty) {
            for (int n = 0; n < this.slots.size(); ++n) {
                if (!((PSUSlot)this.slots.get(n)).isEmpty()) continue;
                this.slots.set(n, (Object)new PSUSlot(stack));
                this.onContentsChanged();
                return ItemStack.EMPTY;
            }
        }
        return stack;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.checkIndex(slot);
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        if (((PSUSlot)this.slots.get(slot)).isEmpty()) {
            if (!simulate) {
                this.slots.set(slot, (Object)new PSUSlot(stack));
                this.onContentsChanged();
            }
            return ItemStack.EMPTY;
        }
        if (((PSUSlot)this.slots.get(slot)).checkItem(stack)) {
            if (!simulate) {
                PSUSlot tmp = (PSUSlot)this.slots.get(slot);
                tmp.incrementCount(stack.getCount(), this.slotCapacity);
                this.onContentsChanged();
            }
            return ItemStack.EMPTY;
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        this.checkIndex(slot);
        PSUSlot tmp = (PSUSlot)this.slots.get(slot);
        if (tmp.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack item = tmp.getStack();
        int extract = Math.min(amount, Math.min(tmp.getCount(), item.getMaxStackSize()));
        item.setCount(extract);
        if (tmp.getCount() <= extract) {
            if (!simulate) {
                this.slots.set(slot, (Object)PSUSlot.EMPTY);
                this.onContentsChanged();
            }
        } else if (!simulate) {
            tmp.decrementCount(extract);
            this.onContentsChanged();
        }
        return item;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return !stack.has(DataComponents.CUSTOM_DATA) && !(stack.getItem() instanceof PocketStorageUnit) && PSUItemHandler.isStandardItem(stack);
    }

    public static boolean isStandardItem(ItemStack stack) {
        return stack.isComponentsPatchEmpty();
    }

    private void onContentsChanged() {
        StorageManager.get().setDirty();
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        ListTag tagList = new ListTag();
        for (PSUSlot slot : this.slots) {
            if (!slot.isEmpty()) {
                tagList.add((Object)slot.writeNBT());
                continue;
            }
            CompoundTag tmp = new CompoundTag();
            tmp.putString("Item", "");
            tmp.putInt("Count", 0);
            tagList.add((Object)tmp);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.put("Slots", (Tag)tagList);
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        if (nbt.contains("Slots")) {
            ListTag tagList = nbt.getList("Slots", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag itemTag = tagList.getCompound(i);
                if (i >= this.slots.size()) continue;
                PSUSlot tmp = new PSUSlot(itemTag);
                this.slots.set(i, (Object)tmp);
            }
        }
    }
}

