/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.client.screens;

import com.direwolf20.laserio.client.screens.LaserGuiGraphics;
import com.direwolf20.laserio.client.screens.widgets.ToggleButton;
import com.direwolf20.laserio.common.containers.FilterCountContainer;
import com.direwolf20.laserio.common.containers.customhandler.FilterCountHandler;
import com.direwolf20.laserio.common.containers.customslot.FilterBasicSlot;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.common.network.data.GhostSlotPayload;
import com.direwolf20.laserio.common.network.data.UpdateFilterPayload;
import com.direwolf20.laserio.util.MiscTools;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class FilterCountScreen
extends AbstractContainerScreen<FilterCountContainer> {
    private final ResourceLocation GUI = ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/filtercount.png");
    protected final FilterCountContainer container;
    private ItemStack filter;
    private boolean isAllowList;
    private boolean isCompareNBT;

    public FilterCountScreen(FilterCountContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.container = container;
        this.filter = container.filterItem;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics = new LaserGuiGraphics(Minecraft.getInstance(), guiGraphics.bufferSource());
        this.updateItemCounts();
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (MiscTools.inBounds(this.getGuiLeft() + 5, this.getGuiTop() + 25, 16, 16, mouseX, mouseY)) {
            if (this.isCompareNBT) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.nbttrue"), mouseX, mouseY);
            } else {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.laserio.nbtfalse"), mouseX, mouseY);
            }
        }
    }

    public void updateItemCounts() {
        FilterCountHandler handler = this.container.handler;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            stack.setCount(this.container.getStackSize(i));
        }
    }

    public void init() {
        super.init();
        Minecraft minecraft = Minecraft.getInstance();
        BlockEntityWithoutLevelRenderer blockentitywithoutlevelrenderer = new BlockEntityWithoutLevelRenderer(minecraft.getBlockEntityRenderDispatcher(), minecraft.getEntityModels());
        ArrayList<ToggleButton> leftWidgets = new ArrayList<ToggleButton>();
        this.isAllowList = FilterCount.getAllowList(this.filter);
        this.isCompareNBT = FilterCount.getCompareNBT(this.filter);
        ResourceLocation[] nbtTextures = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/matchnbtfalse.png"), ResourceLocation.fromNamespaceAndPath((String)"laserio", (String)"textures/gui/buttons/matchnbttrue.png")};
        leftWidgets.add(new ToggleButton(this.getGuiLeft() + 5, this.getGuiTop() + 25, 16, 16, nbtTextures, this.isCompareNBT ? 1 : 0, button -> {
            this.isCompareNBT = !this.isCompareNBT;
            ((ToggleButton)button).setTexturePosition(this.isCompareNBT ? 1 : 0);
        }));
        for (int i = 0; i < leftWidgets.size(); ++i) {
            this.addRenderableWidget((GuiEventListener)((AbstractWidget)leftWidgets.get(i)));
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.GUI, relX, relY, 0, 0, this.imageWidth, this.imageHeight);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        PacketDistributor.sendToServer((CustomPacketPayload)new UpdateFilterPayload(this.isAllowList, this.isCompareNBT), (CustomPacketPayload[])new CustomPacketPayload[0]);
        super.onClose();
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (p_keyPressed_1_ == 256 || this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean mouseClicked(double x, double y, int btn) {
        if (this.hoveredSlot == null || !(this.hoveredSlot instanceof FilterBasicSlot)) {
            return super.mouseClicked(x, y, btn);
        }
        ItemStack stack = ((FilterCountContainer)this.menu).getCarried();
        if (!stack.isEmpty()) {
            stack = stack.copy();
            this.hoveredSlot.set(stack);
            if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.container.filterItem)) {
                return true;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new GhostSlotPayload(this.hoveredSlot.index, stack, stack.getCount(), -1), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.container.handler.setStackInSlot(this.hoveredSlot.index, stack);
        } else {
            int amt;
            ItemStack slotStack = this.hoveredSlot.getItem();
            if (slotStack.isEmpty()) {
                return true;
            }
            if (btn == 2) {
                slotStack.setCount(0);
                PacketDistributor.sendToServer((CustomPacketPayload)new GhostSlotPayload(this.hoveredSlot.index, slotStack, slotStack.getCount(), -1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return true;
            }
            int n = amt = btn == 0 ? 1 : -1;
            if (Screen.hasShiftDown()) {
                amt *= 10;
            }
            if (Screen.hasControlDown()) {
                amt *= 64;
            }
            if (amt + slotStack.getCount() > 4096) {
                amt = 4096 - slotStack.getCount();
            }
            slotStack.grow(amt);
            PacketDistributor.sendToServer((CustomPacketPayload)new GhostSlotPayload(this.hoveredSlot.index, slotStack, slotStack.getCount(), -1), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.container.handler.setStackInSlot(this.hoveredSlot.index, slotStack);
        }
        return true;
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta, double deltaY) {
        if (this.hoveredSlot == null || !(this.hoveredSlot instanceof FilterBasicSlot)) {
            return super.mouseScrolled(mouseX, mouseY, delta, deltaY);
        }
        ItemStack slotStack = this.hoveredSlot.getItem();
        if (slotStack.isEmpty()) {
            return true;
        }
        int amt = (int)delta;
        if (Screen.hasShiftDown()) {
            amt *= 10;
        }
        if (Screen.hasControlDown()) {
            amt *= 64;
        }
        if (amt + slotStack.getCount() > 4096) {
            amt = 4096 - slotStack.getCount();
        }
        if (slotStack.getCount() + amt <= 0) {
            amt = slotStack.getCount() * -1 + 1;
        }
        slotStack.grow(amt);
        PacketDistributor.sendToServer((CustomPacketPayload)new GhostSlotPayload(this.hoveredSlot.index, slotStack, slotStack.getCount(), -1), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return true;
    }

    private static MutableComponent getTrans(String key, Object ... args) {
        return Component.translatable((String)("laserio." + key), (Object[])args);
    }
}

