/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.common.block;

import cy.jdkdigital.utilitarian.module.NoSolicitingModule;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class SolicitingCarpet
extends CarpetBlock {
    public SolicitingCarpet(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH));
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTootipComponents, TooltipFlag pTooltipFlag) {
        BlockItem blockItem;
        super.appendHoverText(pStack, pContext, pTootipComponents, pTooltipFlag);
        pTootipComponents.add((Component)Component.translatable((String)"utilitarian.soliciting_carpet.tooltip").withStyle(ChatFormatting.GOLD));
        Item item = pStack.getItem();
        if (item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock().defaultBlockState().is(NoSolicitingModule.TRAPPED_SOLICITING_CARPETS)) {
            pTootipComponents.add((Component)Component.translatable((String)"utilitarian.soliciting_carpet.tooltip_trapped").withStyle(ChatFormatting.DARK_RED));
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)pContext.getHorizontalDirection());
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)HorizontalDirectionalBlock.FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)HorizontalDirectionalBlock.FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{HorizontalDirectionalBlock.FACING});
    }
}

