/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.client;

import com.google.common.collect.ImmutableSet;
import commoble.morered.MoreRed;
import commoble.morered.client.BlockPreviewRenderer;
import commoble.morered.client.BundledCablePostRenderer;
import commoble.morered.client.ClientConfig;
import commoble.morered.client.ColorHandlers;
import commoble.morered.client.SolderingScreen;
import commoble.morered.client.TintRotatingModelLoader;
import commoble.morered.client.WirePartModelLoader;
import commoble.morered.client.WirePostRenderer;
import commoble.morered.mixin.MultiPlayerGameModeAccess;
import commoble.morered.plate_blocks.LatchBlock;
import commoble.morered.plate_blocks.LogicFunctionPlateBlock;
import commoble.morered.plate_blocks.PlateBlock;
import commoble.morered.plate_blocks.PlateBlockStateProperties;
import commoble.morered.plate_blocks.PulseGateBlock;
import commoble.morered.soldering.SolderingRecipe;
import commoble.morered.util.BlockStateUtil;
import commoble.morered.wire_post.SlackInterpolator;
import commoble.morered.wire_post.WireBreakPacket;
import commoble.morered.wire_post.WirePostBlock;
import commoble.morered.wire_post.WirePostPlateBlock;
import commoble.morered.wires.AbstractWireBlock;
import commoble.morered.wires.RedAlloyWireBlock;
import commoble.morered.wires.VoxelCache;
import commoble.morered.wires.WireUpdatePacket;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class ClientProxy {
    private static final Set<BlockPos> NO_POSTS = ImmutableSet.of();
    private static Map<ChunkPos, Set<BlockPos>> clientPostsInChunk = new HashMap<ChunkPos, Set<BlockPos>>();

    public static void clear() {
        clientPostsInChunk = new HashMap<ChunkPos, Set<BlockPos>>();
    }

    public static void updatePostsInChunk(ChunkPos pos, Set<BlockPos> posts) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        LevelChunk chunk = level.getChunk(pos.x, pos.z);
        if (chunk == null) {
            return;
        }
        chunk.setData((AttachmentType)MoreRed.get().postsInChunkAttachment.get(), Set.copyOf(posts));
    }

    @Nonnull
    public static Set<BlockPos> getPostsInChunk(ChunkPos pos) {
        return clientPostsInChunk.getOrDefault(pos, NO_POSTS);
    }

    public static void initializeAbstractWireBlockClient(final AbstractWireBlock block, Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new IClientBlockExtensions(){

            public boolean addHitEffects(BlockState state, Level Level2, HitResult target, ParticleEngine manager) {
                return block.getWireCount(state) == 0;
            }
        });
    }

    public static void addClientListeners(IEventBus modBus, IEventBus forgeBus) {
        ClientConfig.initClientConfig();
        modBus.addListener(ClientProxy::onClientSetup);
        modBus.addListener(ClientProxy::onRegisterModelLoaders);
        modBus.addListener(ClientProxy::onRegisterBlockColors);
        modBus.addListener(ClientProxy::onRegisterItemColors);
        modBus.addListener(ClientProxy::onRegisterRenderers);
        modBus.addListener(ClientProxy::onRegisterScreens);
        forgeBus.addListener(ClientProxy::onClientLogIn);
        forgeBus.addListener(ClientProxy::onClientLogOut);
        forgeBus.addListener(ClientProxy::onHighlightBlock);
        forgeBus.addListener(ClientProxy::onInteract);
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        MoreRed.get().logicPlates.values().forEach(rob -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)rob.get()), (RenderType)RenderType.cutout()));
        MoreRed.get().bitwiseLogicPlates.values().forEach(rob -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)rob.get()), (RenderType)RenderType.cutout()));
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)MoreRed.get().latchBlock.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)MoreRed.get().pulseGateBlock.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)MoreRed.get().redwirePostPlateBlock.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)MoreRed.get().redwirePostRelayPlateBlock.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)MoreRed.get().bundledCableRelayPlateBlock.get()), (RenderType)RenderType.cutout());
    }

    static void onRegisterScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)MoreRed.get().solderingMenuType.get(), SolderingScreen::new);
    }

    public static void onRegisterModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register(MoreRed.getModRL("wire_parts"), (IGeometryLoader)WirePartModelLoader.INSTANCE);
        event.register(MoreRed.getModRL("rotate_tints"), (IGeometryLoader)TintRotatingModelLoader.INSTANCE);
    }

    public static void onRegisterBlockColors(RegisterColorHandlersEvent.Block event) {
        MoreRed.get().logicPlates.values().forEach(rob -> event.register(ColorHandlers::getLogicFunctionBlockTint, new Block[]{(Block)rob.get()}));
        event.register(ColorHandlers::getLatchBlockTint, new Block[]{(Block)MoreRed.get().latchBlock.get()});
        event.register(ColorHandlers::getPulseGateBlockTint, new Block[]{(Block)MoreRed.get().pulseGateBlock.get()});
        event.register(ColorHandlers::getRedwirePostBlockTint, new Block[]{(Block)MoreRed.get().redwirePostBlock.get()});
        event.register(ColorHandlers::getRedwirePostBlockTint, new Block[]{(Block)MoreRed.get().redwirePostPlateBlock.get()});
        event.register(ColorHandlers::getRedwirePostBlockTint, new Block[]{(Block)MoreRed.get().redwirePostRelayPlateBlock.get()});
        event.register(ColorHandlers::getRedAlloyWireBlockTint, new Block[]{(Block)MoreRed.get().redAlloyWireBlock.get()});
    }

    public static void onRegisterItemColors(RegisterColorHandlersEvent.Item event) {
        MoreRed.get().logicPlates.values().forEach(rob -> event.register(ColorHandlers::getLogicFunctionBlockItemTint, new ItemLike[]{((LogicFunctionPlateBlock)((Object)((Object)rob.get()))).asItem()}));
        event.register(ColorHandlers::getLatchItemTint, new ItemLike[]{((LatchBlock)((Object)MoreRed.get().latchBlock.get())).asItem()});
        event.register(ColorHandlers::getPulseGateItemTint, new ItemLike[]{((PulseGateBlock)((Object)MoreRed.get().pulseGateBlock.get())).asItem()});
        event.register(ColorHandlers::getRedwirePostItemTint, new ItemLike[]{((WirePostBlock)((Object)MoreRed.get().redwirePostBlock.get())).asItem()});
        event.register(ColorHandlers::getRedwirePostItemTint, new ItemLike[]{((WirePostPlateBlock)((Object)MoreRed.get().redwirePostPlateBlock.get())).asItem()});
        event.register(ColorHandlers::getRedwirePostItemTint, new ItemLike[]{((WirePostPlateBlock)((Object)MoreRed.get().redwirePostRelayPlateBlock.get())).asItem()});
        event.register(ColorHandlers::getRedAlloyWireItemTint, new ItemLike[]{((RedAlloyWireBlock)((Object)MoreRed.get().redAlloyWireBlock.get())).asItem()});
    }

    static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)MoreRed.get().redwirePostBeType.get(), WirePostRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)MoreRed.get().bundledCablePostBeType.get(), BundledCablePostRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)MoreRed.get().bundledCableRelayPlateBeType.get(), BundledCablePostRenderer::new);
    }

    static void onClientLogIn(ClientPlayerNetworkEvent.LoggingIn event) {
        ClientProxy.clear();
    }

    static void onClientLogOut(ClientPlayerNetworkEvent.LoggingOut event) {
        ClientProxy.clear();
    }

    static void onHighlightBlock(RenderHighlightEvent.Block event) {
        BlockItem blockItem;
        Block block;
        InteractionHand hand;
        Item item;
        LocalPlayer player;
        if (((Boolean)ClientConfig.INSTANCE.showPlacementPreview().get()).booleanValue() && (player = Minecraft.getInstance().player) != null && player.level() != null && (item = player.getItemInHand((hand = player.getUsedItemHand()) == null ? InteractionHand.MAIN_HAND : hand).getItem()) instanceof BlockItem && (block = (blockItem = (BlockItem)item).getBlock()) instanceof PlateBlock) {
            Level world = player.level();
            BlockHitResult rayTrace = event.getTarget();
            Direction directionAwayFromTargetedBlock = rayTrace.getDirection();
            BlockPos placePos = rayTrace.getBlockPos().relative(directionAwayFromTargetedBlock);
            BlockState existingState = world.getBlockState(placePos);
            if (existingState.isAir() || existingState.canBeReplaced()) {
                Vec3 hitVec = rayTrace.getLocation();
                Direction attachmentDirection = directionAwayFromTargetedBlock.getOpposite();
                Vec3 relativeHitVec = hitVec.subtract(Vec3.atLowerCornerOf((Vec3i)placePos));
                Direction outputDirection = BlockStateUtil.getOutputDirectionFromRelativeHitVec(relativeHitVec, attachmentDirection);
                BlockStateUtil.getRotationIndexForDirection(attachmentDirection, outputDirection);
                BlockState state = PlateBlockStateProperties.getStateForPlacedGatePlate(block.defaultBlockState(), placePos, attachmentDirection, relativeHitVec);
                BlockPreviewRenderer.renderBlockPreview(placePos, state, world, event.getCamera().getPosition(), event.getPoseStack(), event.getMultiBufferSource());
            }
        }
    }

    public static void onInteract(InputEvent.InteractionKeyMappingTriggered event) {
        BlockHitResult blockResult;
        BlockPos pos;
        BlockState state;
        Block block;
        Minecraft mc = Minecraft.getInstance();
        HitResult rayTraceResult = mc.hitResult;
        ClientLevel world = mc.level;
        LocalPlayer player = mc.player;
        if (rayTraceResult != null && rayTraceResult.getLocation() != null && world != null && event.isAttack() && player != null && rayTraceResult.getType() == HitResult.Type.BLOCK && (block = (state = world.getBlockState(pos = (blockResult = (BlockHitResult)rayTraceResult).getBlockPos())).getBlock()) instanceof AbstractWireBlock) {
            event.setCanceled(true);
            AbstractWireBlock wireBlock = (AbstractWireBlock)block;
            MultiPlayerGameMode controller = mc.gameMode;
            MultiPlayerGameModeAccess controllerAccess = (MultiPlayerGameModeAccess)controller;
            GameType gameType = controller.getPlayerMode();
            if (player.blockActionRestricted((Level)world, pos, gameType)) {
                return;
            }
            if (!world.getWorldBorder().isWithinBounds(pos)) {
                return;
            }
            Direction faceToBreak = wireBlock.getInteriorFaceToBreak(state, pos, (Player)player, blockResult, mc.getTimer().getGameTimeDeltaPartialTick(false));
            if (faceToBreak == null) {
                return;
            }
            Direction hitNormal = faceToBreak.getOpposite();
            if (gameType.isCreative()) {
                Minecraft.getInstance().getConnection().send((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, pos, hitNormal));
                if (!CommonHooks.onLeftClickBlock((Player)player, (BlockPos)pos, (Direction)hitNormal, (ServerboundPlayerActionPacket.Action)ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK).isCanceled()) {
                    ClientProxy.destroyClickedWireBlock(wireBlock, state, world, pos, player, controllerAccess, faceToBreak);
                }
                controllerAccess.setDestroyDelay(5);
            } else if (!controller.isDestroying() || !controllerAccess.callSameDestroyTarget(pos)) {
                if (controller.isDestroying()) {
                    Minecraft.getInstance().getConnection().send((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK, controllerAccess.getDestroyBlockPos(), blockResult.getDirection()));
                }
                PlayerInteractEvent.LeftClickBlock leftClickBlockEvent = CommonHooks.onLeftClickBlock((Player)player, (BlockPos)pos, (Direction)hitNormal, (ServerboundPlayerActionPacket.Action)ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK);
                Minecraft.getInstance().getConnection().send((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, pos, hitNormal));
                if (!leftClickBlockEvent.isCanceled() && leftClickBlockEvent.getUseItem() != TriState.FALSE) {
                    ClientProxy.destroyClickedWireBlock(wireBlock, state, world, pos, player, controllerAccess, faceToBreak);
                }
            }
        }
    }

    static void destroyClickedWireBlock(AbstractWireBlock block, BlockState state, ClientLevel world, BlockPos pos, LocalPlayer player, MultiPlayerGameModeAccess controllerAccess, Direction interiorSide) {
        ItemStack heldItemStack = player.getMainHandItem();
        if (!heldItemStack.getItem().canAttackBlock(state, (Level)world, pos, (Player)player)) {
            return;
        }
        controllerAccess.setIsDestroying(false);
        block.destroyClickedSegment(state, (Level)world, pos, (Player)player, interiorSide, false);
        controllerAccess.setDestroyProgress(0.0f);
        controllerAccess.setDestroyTicks(0.0f);
    }

    public static void onWireBreakPacket(WireBreakPacket packet) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel world = mc.level;
        if (world != null) {
            Vec3[] points = SlackInterpolator.getInterpolatedPoints(packet.start(), packet.end());
            ParticleEngine manager = mc.particleEngine;
            BlockState state = Blocks.REDSTONE_WIRE.defaultBlockState();
            for (Vec3 point : points) {
                manager.add(new TerrainParticle(world, point.x, point.y, point.z, 0.0, 0.0, 0.0, state).setPower(0.2f).scale(0.6f));
            }
        }
    }

    public static void onWireUpdatePacket(WireUpdatePacket packet) {
        ClientLevel world = Minecraft.getInstance().level;
        if (world != null) {
            packet.positions().forEach(pos -> VoxelCache.invalidate((Level)world, pos));
        }
    }

    public static List<RecipeHolder<SolderingRecipe>> getAllSolderingRecipes(RecipeManager manager, RegistryAccess registries) {
        return manager.getAllRecipesFor((RecipeType)MoreRed.get().solderingRecipeType.get()).stream().sorted(Comparator.comparing(recipe -> I18n.get((String)((SolderingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)registries).getDescriptionId(), (Object[])new Object[0]))).toList();
    }
}

