/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.network.packet;

import com.nine.travelerscompass.common.container.menu.CompassMenu;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record GhostTargetPacket(int id, ItemStack stack) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GhostTargetPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"ghost_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, GhostTargetPacket> PACKET_CODEC = StreamCodec.ofMember(GhostTargetPacket::write, GhostTargetPacket::read);

    public static GhostTargetPacket read(RegistryFriendlyByteBuf buf) {
        return new GhostTargetPacket(buf.readInt(), (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf));
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.id);
        ItemStack.STREAM_CODEC.encode((Object)buf, (Object)this.stack);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static void onMessage(GhostTargetPacket packet, IPayloadContext ctx) {
        Player player = ctx.player();
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof CompassMenu) {
            CompassMenu menu = (CompassMenu)abstractContainerMenu;
            ((Slot)menu.slots.get(packet.id)).set(packet.stack);
        }
    }
}

