/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.network.packet;

import com.nine.travelerscompass.TCConfig;
import com.nine.travelerscompass.common.item.CompassData;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ConfigButtonPacket(int value, boolean controlPressed, boolean shiftPressed) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ConfigButtonPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"travelerscompass", (String)"config_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ConfigButtonPacket> PACKET_CODEC = StreamCodec.ofMember(ConfigButtonPacket::write, ConfigButtonPacket::read);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static ConfigButtonPacket read(RegistryFriendlyByteBuf buf) {
        return new ConfigButtonPacket(buf.readInt(), buf.readBoolean(), buf.readBoolean());
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.value);
        buf.writeBoolean(this.controlPressed);
        buf.writeBoolean(this.shiftPressed);
    }

    public static void onMessage(ConfigButtonPacket packet, IPayloadContext ctx) {
        Player player = ctx.player();
        ItemStack stack = Objects.requireNonNull(player).getMainHandItem();
        Item item = stack.getItem();
        if (item instanceof TravelersCompassItem) {
            TravelersCompassItem travelersCompassItem = (TravelersCompassItem)item;
            boolean controlPressed = packet.controlPressed;
            boolean shiftPressed = packet.shiftPressed;
            int amount = (shiftPressed ? -1 : 1) * (controlPressed ? 5 : 1);
            switch (packet.value) {
                case 0: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_MOBS);
                    break;
                }
                case 1: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_BLOCKS);
                    break;
                }
                case 2: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_CONTAINERS);
                    break;
                }
                case 3: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_FLUIDS);
                    break;
                }
                case 4: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_VILLAGERS);
                    break;
                }
                case 5: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_SPAWNERS);
                    break;
                }
                case 6: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_ENTITIES_INV);
                    break;
                }
                case 7: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_DROPPED_ITEMS);
                    break;
                }
                case 8: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_ENTITIES_DROP);
                    break;
                }
                case -1: {
                    travelersCompassItem.writeCompassData(stack, CompassData.PAUSED);
                    break;
                }
                case -3: {
                    if (player.level().isClientSide()) break;
                    if (!travelersCompassItem.isPaused(stack)) {
                        travelersCompassItem.writeCompassData(stack, CompassData.PAUSED);
                    }
                    travelersCompassItem.writeCompassData(stack, CompassData.WIDE_SEARCH_SIGNAL);
                    break;
                }
                case -5: {
                    int currentRadius = travelersCompassItem.blockSearchRadius(stack);
                    if (currentRadius + amount > (Integer)TCConfig.blockSearchRadius.get() || currentRadius + amount <= 0) break;
                    travelersCompassItem.setBlockSearchRadius(stack, currentRadius + amount);
                    break;
                }
                case -6: {
                    int currentRadius = travelersCompassItem.entitySearchRadius(stack);
                    if (currentRadius + amount > (Integer)TCConfig.entitySearchRadius.get() || currentRadius + amount <= 0) break;
                    travelersCompassItem.setEntitySearchRadius(stack, currentRadius + amount);
                    break;
                }
                case -7: {
                    int currentRadius = travelersCompassItem.containerSearchRadius(stack);
                    if (currentRadius + amount > (Integer)TCConfig.containerSearchRadius.get() || currentRadius + amount <= 0) break;
                    travelersCompassItem.setContainerSearchRadius(stack, currentRadius + amount);
                    break;
                }
                case -8: {
                    int currentRadius = travelersCompassItem.wideSearchRadius(stack);
                    if (currentRadius + amount > (Integer)TCConfig.wideSearchRadius.get() || currentRadius + amount <= 0) break;
                    travelersCompassItem.setWideSearchRadius(stack, currentRadius + amount);
                    break;
                }
                case -9: {
                    travelersCompassItem.writeCompassData(stack, CompassData.PRIORITY_MODE);
                    break;
                }
                case -10: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SHOW_LABELS);
                    break;
                }
                case -11: {
                    if (travelersCompassItem.hudMode(stack)) {
                        travelersCompassItem.writeCompassData(stack, CompassData.HUD_SHOW);
                        break;
                    }
                    if (travelersCompassItem.hudModeRequiresHeld(stack)) {
                        travelersCompassItem.writeCompassData(stack, CompassData.HUD_SHOW_HAND);
                        travelersCompassItem.writeCompassData(stack, CompassData.HUD_SHOW);
                        break;
                    }
                    travelersCompassItem.writeCompassData(stack, CompassData.HUD_SHOW_HAND);
                    break;
                }
                case -12: {
                    travelersCompassItem.setContainerSearchRadius(stack, (int)((float)((Integer)TCConfig.containerSearchRadius.get()).intValue() * 0.5f));
                    travelersCompassItem.setEntitySearchRadius(stack, (int)((float)((Integer)TCConfig.entitySearchRadius.get()).intValue() * 0.5f));
                    travelersCompassItem.setBlockSearchRadius(stack, (int)((float)((Integer)TCConfig.blockSearchRadius.get()).intValue() * 0.5f));
                    travelersCompassItem.setWideSearchRadius(stack, (int)((float)((Integer)TCConfig.wideSearchRadius.get()).intValue() * 0.5f));
                    if (travelersCompassItem.showLabels(stack)) {
                        travelersCompassItem.writeCompassData(stack, CompassData.SHOW_LABELS);
                    }
                    if (!travelersCompassItem.priorityMode(stack)) {
                        travelersCompassItem.writeCompassData(stack, CompassData.PRIORITY_MODE);
                    }
                    if (travelersCompassItem.hudMode(stack)) {
                        travelersCompassItem.writeCompassData(stack, CompassData.HUD_SHOW);
                        break;
                    }
                    if (!travelersCompassItem.hudModeRequiresHeld(stack)) break;
                    travelersCompassItem.writeCompassData(stack, CompassData.HUD_SHOW_HAND);
                    break;
                }
                case -13: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SOUND);
                    break;
                }
                case -14: {
                    travelersCompassItem.writeCompassData(stack, CompassData.LAZY_MODE);
                    break;
                }
                case 401: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_VILLAGERS_GOODS);
                    break;
                }
                case 402: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_VILLAGERS_COST);
                    break;
                }
                case 601: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_PLAYERS_INV);
                    break;
                }
                case 602: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_MOBS_INV);
                    break;
                }
                case 603: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_MINECARTS_INV);
                }
            }
        }
    }
}

