/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.render.item;

import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class CustomCompassItemPropertyFunction
implements ClampedItemPropertyFunction {
    private final CompassWobble wobble = new CompassWobble();
    private final CompassWobble wobbleRandom = new CompassWobble();
    public final CompassTarget compassTarget;

    public CustomCompassItemPropertyFunction(CompassTarget pCompassTarget) {
        this.compassTarget = pCompassTarget;
    }

    public float unclampedCall(ItemStack pStack, @Nullable ClientLevel pLevel, @Nullable LivingEntity pEntity, int pSeed) {
        LivingEntity entity;
        Object object = entity = pEntity != null ? pEntity : pStack.getEntityRepresentation();
        if (entity == null) {
            return 0.0f;
        }
        return (pLevel = this.tryFetchLevelIfMissing((Entity)entity, pLevel)) == null ? 0.0f : this.getCompassRotation(pStack, pLevel, pSeed, (Entity)entity);
    }

    private float getCompassRotation(ItemStack pStack, ClientLevel pLevel, int pSeed, Entity pEntity) {
        BlockPos pos = this.compassTarget.getPos(pLevel, pStack, pEntity);
        long i = pLevel.getGameTime();
        return !this.isValidCompassTargetPos(pEntity, pos) ? this.getRandomlySpinningRotation(pSeed, i) : this.getRotationTowardsCompassTarget(pEntity, i, pos);
    }

    private float getRandomlySpinningRotation(int pSeed, long pTicks) {
        if (this.wobbleRandom.shouldUpdate(pTicks)) {
            this.wobbleRandom.update(pTicks, Math.random());
        }
        double d0 = this.wobbleRandom.rotation + (double)((float)this.hash(pSeed) / 2.1474836E9f);
        return Mth.positiveModulo((float)((float)d0), (float)1.0f);
    }

    private float getRotationTowardsCompassTarget(Entity pEntity, long pTicks, BlockPos pPos) {
        Player player;
        double d0 = this.getAngleFromEntityToPos(pEntity, pPos);
        double d1 = this.getWrappedVisualRotationY(pEntity);
        if (pEntity instanceof Player && (player = (Player)pEntity).isLocalPlayer()) {
            if (this.wobble.shouldUpdate(pTicks)) {
                this.wobble.update(pTicks, 0.5 - (d1 - 0.25));
            }
            double d3 = d0 + this.wobble.rotation;
            return Mth.positiveModulo((float)((float)d3), (float)1.0f);
        }
        double d2 = 0.5 - (d1 - 0.25 - d0);
        return Mth.positiveModulo((float)((float)d2), (float)1.0f);
    }

    @Nullable
    private ClientLevel tryFetchLevelIfMissing(Entity pEntity, @Nullable ClientLevel pLevel) {
        return pLevel == null && pEntity.level() instanceof ClientLevel ? (ClientLevel)pEntity.level() : pLevel;
    }

    private boolean isValidCompassTargetPos(Entity pEntity, @Nullable BlockPos pPos) {
        return pPos != null;
    }

    private double getAngleFromEntityToPos(Entity pEntity, BlockPos pPos) {
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)pPos);
        return Math.atan2(vec3.z() - pEntity.getZ(), vec3.x() - pEntity.getX()) / 6.2831854820251465;
    }

    private double getWrappedVisualRotationY(Entity pEntity) {
        return Mth.positiveModulo((double)(pEntity.getVisualRotationYInDegrees() / 360.0f), (double)1.0);
    }

    private int hash(int pValue) {
        return pValue * 1327217883;
    }

    @OnlyIn(value=Dist.CLIENT)
    static class CompassWobble {
        double rotation;
        private double deltaRotation;
        private long lastUpdateTick;

        CompassWobble() {
        }

        boolean shouldUpdate(long pTicks) {
            return this.lastUpdateTick != pTicks;
        }

        void update(long pTicks, double pRotation) {
            this.lastUpdateTick = pTicks;
            double d0 = pRotation - this.rotation;
            d0 = Mth.positiveModulo((double)(d0 + 0.5), (double)1.0) - 0.5;
            this.deltaRotation += d0 * 0.1;
            this.deltaRotation *= 0.8;
            this.rotation = Mth.positiveModulo((double)(this.rotation + this.deltaRotation), (double)1.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface CompassTarget {
        @Nullable
        public BlockPos getPos(ClientLevel var1, ItemStack var2, Entity var3);
    }
}

