/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.powercell.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.client.HudRenderHelper;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsbase.modules.informationscreen.blocks.DefaultPowerInformationScreenInfo;
import mcjty.rftoolsbase.modules.informationscreen.client.DefaultPowerInformationRenderer;
import mcjty.rftoolspower.modules.powercell.blocks.PowerCellInformationScreenInfo;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;

public class PowerCellInformationRenderer {
    public static void renderGraphical(PoseStack matrixStack, MultiBufferSource buffer, int mode, TypedMap data, Direction orientation, double scale) {
        if (data == null || data.size() == 0) {
            return;
        }
        long energy = data.getOptional(DefaultPowerInformationScreenInfo.ENERGY).orElse(0L);
        long maxEnergy = data.getOptional(DefaultPowerInformationScreenInfo.MAXENERGY).orElse(0L);
        long rfExtractPerTick = data.getOptional(PowerCellInformationScreenInfo.RFEXTRACT_PERTICK).orElse(0L);
        long rfInsertPerTick = data.getOptional(PowerCellInformationScreenInfo.RFINSERT_PERTICK).orElse(0L);
        long roughMaxRfPerTick = data.getOptional(PowerCellInformationScreenInfo.ROUGH_MAXRF_PERTICK).orElse(0L);
    }

    public static void renderDefault(PoseStack matrixStack, MultiBufferSource buffer, TypedMap data, Direction orientation, double scale) {
        List<String> log = PowerCellInformationRenderer.getLog(data);
        HudRenderHelper.HudPlacement hudPlacement = HudRenderHelper.HudPlacement.HUD_FRONT;
        HudRenderHelper.HudOrientation hudOrientation = HudRenderHelper.HudOrientation.HUD_SOUTH;
        HudRenderHelper.renderHud((PoseStack)matrixStack, (MultiBufferSource)buffer, log, (HudRenderHelper.HudPlacement)hudPlacement, (HudRenderHelper.HudOrientation)hudOrientation, (Direction)orientation, (double)((double)(-orientation.getStepX()) * 0.95), (double)0.0, (double)((double)(-orientation.getStepZ()) * 0.95), (float)((float)(1.0 + scale)));
    }

    private static List<String> getLog(TypedMap data) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("");
        if (data != null && data.size() > 0) {
            long energy = (Long)data.get(DefaultPowerInformationScreenInfo.ENERGY);
            long maxEnergy = (Long)data.get(DefaultPowerInformationScreenInfo.MAXENERGY);
            long rfExtractPerTick = (Long)data.get(PowerCellInformationScreenInfo.RFEXTRACT_PERTICK);
            long rfInsertPerTick = (Long)data.get(PowerCellInformationScreenInfo.RFINSERT_PERTICK);
            list.add(String.valueOf(ChatFormatting.BLUE) + " RF: " + String.valueOf(ChatFormatting.WHITE) + DefaultPowerInformationRenderer.formatPower((long)energy));
            list.add(String.valueOf(ChatFormatting.BLUE) + " Max: " + String.valueOf(ChatFormatting.WHITE) + DefaultPowerInformationRenderer.formatPower((long)maxEnergy));
            if (rfExtractPerTick != -1L) {
                list.add(String.valueOf(ChatFormatting.BLUE) + " Ext/t: " + String.valueOf(ChatFormatting.WHITE) + DefaultPowerInformationRenderer.formatPower((long)rfExtractPerTick));
                list.add(String.valueOf(ChatFormatting.BLUE) + " Ins/t: " + String.valueOf(ChatFormatting.WHITE) + DefaultPowerInformationRenderer.formatPower((long)rfInsertPerTick));
            }
        } else {
            list.add(String.valueOf(ChatFormatting.RED) + " Not a powercell");
            list.add(String.valueOf(ChatFormatting.RED) + " or anything that");
            list.add(String.valueOf(ChatFormatting.RED) + " supports power");
        }
        return list;
    }
}

