/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.endergenic.blocks;

import java.util.HashSet;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.container.ItemInventory;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsbase.tools.TickOrderHandler;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.endergenic.EndergenicModule;
import mcjty.rftoolspower.modules.endergenic.blocks.EndergenicTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.Lazy;

public class PearlInjectorTileEntity
extends TickingTileEntity
implements TickOrderHandler.IOrderTicker {
    public static final int BUFFER_SIZE = 18;
    public static final int SLOT_BUFFER = 0;
    public static final int SLOT_PLAYERINV = 18;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(18).box(SlotDefinition.specific((Item[])new Item[]{Items.ENDER_PEARL}).in(), 0, 10, 25, 9, 2).playerSlots(10, 70));
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid(GenericItemHandler.match((Item)Items.ENDER_PEARL)).build();
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private static final Function<PearlInjectorTileEntity, GenericItemHandler> ITEM_CAP = be -> be.items;
    @Cap(type=CapType.CONTAINER)
    private static final Function<PearlInjectorTileEntity, MenuProvider> SCREEN_CAP = be -> new DefaultContainerProvider("Pearl Injector").containerSupplier(DefaultContainerProvider.container(EndergenicModule.CONTAINER_PEARL_INJECTOR, CONTAINER_FACTORY, (GenericTileEntity)be)).itemHandler(() -> be.items).setupSync((GenericTileEntity)be);
    private boolean prevIn = false;

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsbase:powergeneration/pearlinjector")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(PearlInjectorTileEntity::new));
    }

    public PearlInjectorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EndergenicModule.PEARL_INJECTOR.be().get(), pos, state);
    }

    public EndergenicTileEntity findEndergenicTileEntity() {
        BlockState state = this.level.getBlockState(this.getBlockPos());
        Direction k = OrientationTools.getOrientation((BlockState)state);
        EndergenicTileEntity te = this.getEndergenicGeneratorAt(k.getOpposite());
        if (te != null) {
            return te;
        }
        return this.getEndergenicGeneratorAt(Direction.UP);
    }

    private EndergenicTileEntity getEndergenicGeneratorAt(Direction k) {
        BlockPos o = this.getBlockPos().relative(k);
        BlockEntity te = this.level.getBlockEntity(o);
        if (te instanceof EndergenicTileEntity) {
            return (EndergenicTileEntity)te;
        }
        return null;
    }

    protected void tickServer() {
        long ticker = TickOrderHandler.getTicker();
        TickOrderHandler.queue((TickOrderHandler.IOrderTicker)this);
        HashSet<BlockPos> connectedEndergenics = new HashSet<BlockPos>();
        for (EndergenicTileEntity endergenic = this.findEndergenicTileEntity(); endergenic != null && !connectedEndergenics.contains(endergenic.getBlockPos()); endergenic = endergenic.getDestinationTE()) {
            if (ticker != endergenic.getTicker()) {
                endergenic.setTicker(ticker);
                TickOrderHandler.queue((TickOrderHandler.IOrderTicker)endergenic);
            }
            connectedEndergenics.add(endergenic.getBlockPos());
        }
    }

    public TickOrderHandler.Rank getRank() {
        return TickOrderHandler.Rank.RANK_0;
    }

    public void tickOnServer() {
        boolean pulse = this.powerLevel > 0 && !this.prevIn;
        if (this.prevIn == this.powerLevel > 0) {
            return;
        }
        boolean bl = this.prevIn = this.powerLevel > 0;
        if (pulse) {
            this.injectPearl();
        }
        this.setChanged();
    }

    private boolean takePearl() {
        for (int i = 0; i < this.items.getSlots(); ++i) {
            ItemStack stack = this.items.getStackInSlot(i);
            if (stack.isEmpty() || !Items.ENDER_PEARL.equals(stack.getItem()) || stack.getCount() <= 0) continue;
            this.items.decrStackSize(i, 1);
            return true;
        }
        return false;
    }

    public void injectPearl() {
        EndergenicTileEntity endergen = this.findEndergenicTileEntity();
        if (endergen != null) {
            if (!this.takePearl()) {
                return;
            }
            int mode = endergen.getChargingMode();
            if (mode != -1) {
                endergen.firePearlFromInjector();
            }
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.prevIn = tag.getBoolean("prevIn");
        this.items.load(tag, "items", provider);
    }

    public void saveAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putBoolean("prevIn", this.prevIn);
        this.items.save(tag, "items", provider);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.items.applyImplicitComponents((ItemInventory)input.get((Supplier)Registration.ITEM_INVENTORY));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        this.items.collectImplicitComponents(builder);
    }
}

