/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstoragecreateintegration.common;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ISyncedContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageBase;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageContentsPayload;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageSettingsContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstoragecreateintegration.common.MountedStorageSettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedstoragecreateintegration.init.ModContent;
import net.p3pp3rf1y.sophisticatedstoragecreateintegration.storage.MountedSophisticatedStorage;

public class MountedStorageContainerMenu
extends MountedStorageContainerMenuBase
implements ISyncedContainer {
    public MountedStorageContainerMenu(int containerId, Player player, int contraptionEntityId, BlockPos localPos) {
        this(ModContent.MOUNTED_STORAGE_CONTAINER_TYPE.get(), containerId, player, contraptionEntityId, localPos);
    }

    public MountedStorageContainerMenu(MenuType<?> menuType, int containerId, Player player, int contraptionEntityId, BlockPos localPos) {
        super(menuType, containerId, player, (IStorageWrapper)NoopStorageWrapper.INSTANCE, -1, false, contraptionEntityId, localPos);
        this.getContraptionEntity().ifPresent(contraptionEntity -> {
            MountedStorageBase patt0$temp = this.mountedStorage;
            if (patt0$temp instanceof MountedSophisticatedStorage) {
                MountedSophisticatedStorage mountedSophisticatedStorage = (MountedSophisticatedStorage)patt0$temp;
                mountedSophisticatedStorage.getStorageHolder().startOpen(player, (Entity)contraptionEntity);
            }
        });
    }

    public static MountedStorageContainerMenu fromBuffer(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new MountedStorageContainerMenu(windowId, playerInventory.player, buffer.readInt(), buffer.readBlockPos());
    }

    public void removed(Player player) {
        super.removed(player);
        this.getContraptionEntity().ifPresent(contraptionEntity -> {
            MountedStorageBase patt0$temp = this.mountedStorage;
            if (patt0$temp instanceof MountedSophisticatedStorage) {
                MountedSophisticatedStorage mountedSophisticatedStorage = (MountedSophisticatedStorage)patt0$temp;
                mountedSophisticatedStorage.getStorageHolder().stopOpen(player, (Entity)contraptionEntity);
            }
        });
    }

    protected StorageContainerMenuBase.StorageUpgradeSlot instantiateUpgradeSlot(UpgradeHandler upgradeHandler, int slotIndex) {
        return new StorageContainerMenuBase.StorageUpgradeSlot(upgradeHandler, slotIndex){

            protected void onUpgradeChanged() {
                if (MountedStorageContainerMenu.this.player.level().isClientSide()) {
                    return;
                }
                ((ItemDisplaySettingsCategory)MountedStorageContainerMenu.this.storageWrapper.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class)).itemsChanged();
            }
        };
    }

    protected MountedStorageSettingsContainerMenuBase instantiateSettingsContainerMenu(int windowId, Player player, int contraptionEntityId, BlockPos localPos) {
        return new MountedStorageSettingsContainerMenu(windowId, player, contraptionEntityId, localPos);
    }

    protected void writeSettingsContainerMenuExtraData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.getEntity().map(Entity::getId).orElse(-1).intValue());
        buffer.writeBlockPos(this.localPos);
    }

    protected CompoundTag getSettingsTag(CompoundTag contents) {
        return contents.getCompound("settings");
    }

    public float getSlotFillPercentage(int slot) {
        List slotFillRatios = this.getMountedStorage().map(m -> m.getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo().getSlotFillRatios()).orElse(Collections.emptyList());
        return slot > -1 && slot < slotFillRatios.size() ? ((Float)slotFillRatios.get(slot)).floatValue() : 0.0f;
    }

    protected String getSettingsTitleKey() {
        return StorageTranslationHelper.INSTANCE.translGui("settings.title");
    }

    protected CustomPacketPayload instantiateSettingsPayload(UUID uuid, CompoundTag settingsContents) {
        return new MountedStorageContentsPayload(uuid, settingsContents);
    }
}

