/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.block;

import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.entity.SmokerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.theme.SecondaryTheme;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.IBlockPlacementHandler;

public class Furnace
implements IBlockPlacementHandler {
    private static final Item[] FOOD = new Item[]{Items.COOKED_BEEF, Items.COOKED_CHICKEN, Items.COOKED_MUTTON, Items.COOKED_COD, Items.COOKED_PORKCHOP, Items.COOKED_RABBIT, Items.COOKED_SALMON, Items.BAKED_POTATO};

    @Override
    public void place(LevelAccessor world, BlockState state, BlockPos pos, RandomSource rand, Theme theme, SecondaryTheme secondaryTheme, int lootLevel) {
        world.setBlock(pos, state, 2);
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof FurnaceBlockEntity) {
            FurnaceBlockEntity furnace = (FurnaceBlockEntity)tile;
            furnace.setItem(1, new ItemStack((ItemLike)Items.COAL, Furnace.coalAmount(rand)));
        } else {
            DungeonCrawl.LOGGER.warn("Failed to fetch a furnace entity at {}", (Object)pos.toString());
        }
    }

    private static int coalAmount(RandomSource rand) {
        return Mth.nextInt((RandomSource)rand, (int)2, (int)8);
    }

    public static class Smoker
    implements IBlockPlacementHandler {
        @Override
        public void place(LevelAccessor world, BlockState state, BlockPos pos, RandomSource rand, Theme theme, SecondaryTheme secondaryTheme, int lootLevel) {
            world.setBlock(pos, state, 2);
            BlockEntity tile = world.getBlockEntity(pos);
            if (tile instanceof SmokerBlockEntity) {
                SmokerBlockEntity smoker = (SmokerBlockEntity)tile;
                smoker.setItem(1, new ItemStack((ItemLike)Items.CHARCOAL, Furnace.coalAmount(rand)));
                smoker.setItem(2, new ItemStack((ItemLike)FOOD[rand.nextInt(FOOD.length)], 1 + rand.nextInt(16)));
            } else {
                DungeonCrawl.LOGGER.warn("Failed to fetch a smoker entity at {}", (Object)pos.toString());
            }
        }
    }
}

