/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.recipe;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.CommonHooks;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.item.ItemFacade;

public class ItemFacadeRecipe
extends CustomRecipe {
    private NonNullList<Ingredient> ingredients;

    public ItemFacadeRecipe(CraftingBookCategory craftingBookCategory) {
        super(craftingBookCategory);
    }

    public NonNullList<Ingredient> getIngredients() {
        if (this.ingredients == null) {
            try {
                this.ingredients = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemStack[])new ItemStack[]{this.getResultItem()}), Ingredient.of(BuiltInRegistries.BLOCK.stream().map(ItemStack::new))});
            }
            catch (RuntimeException e) {
                return NonNullList.create();
            }
        }
        return this.ingredients;
    }

    public boolean matches(CraftingInput grid, Level world) {
        return !this.assemble(grid, (HolderLookup.Provider)world.registryAccess()).isEmpty();
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return this.getResultItem();
    }

    public ItemStack getResultItem() {
        return new ItemStack(RegistryEntries.ITEM_FACADE);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inventory) {
        NonNullList aitemstack = NonNullList.withSize((int)inventory.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < aitemstack.size(); ++i) {
            ItemStack itemstack = inventory.getItem(i);
            aitemstack.set(i, (Object)CommonHooks.getCraftingRemainingItem((ItemStack)itemstack));
        }
        return aitemstack;
    }

    public ItemStack assemble(CraftingInput grid, HolderLookup.Provider registryAccess) {
        ItemStack output = this.getResultItem(registryAccess).copy();
        int facades = 0;
        ItemStack block = ItemStack.EMPTY;
        for (int j = 0; j < grid.size(); ++j) {
            ItemStack element = grid.getItem(j);
            if (element.isEmpty()) continue;
            if (element.getItem() == output.getItem()) {
                ++facades;
                continue;
            }
            if (block.isEmpty() && element.getItem() instanceof BlockItem && !((BlockItem)element.getItem()).getBlock().defaultBlockState().useShapeForLightOcclusion()) {
                block = element;
                continue;
            }
            return ItemStack.EMPTY;
        }
        if (facades != 1 || block.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ((ItemFacade)((Object)RegistryEntries.ITEM_FACADE.get())).writeFacadeBlock(output, BlockHelpers.getBlockStateFromItemStack((ItemStack)block));
        return output;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RegistryEntries.RECIPESERIALIZER_FACADE.get();
    }
}

