/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.part.aspect.read;

import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.AspectUpdateType;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectRead;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectVariable;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.read.IPartStateReader;
import org.cyclops.integrateddynamics.api.part.read.IPartTypeReader;
import org.cyclops.integrateddynamics.core.part.aspect.LazyAspectVariable;
import org.cyclops.integrateddynamics.part.aspect.AspectBase;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public abstract class AspectReadBase<V extends IValue, T extends IValueType<V>>
extends AspectBase<V, T>
implements IAspectRead<V, T> {
    private final String unlocalizedTypeSuffix;
    private final AspectUpdateType updateType;

    public AspectReadBase(ModBase mod, String unlocalizedTypeSuffix, IAspectProperties defaultProperties, AspectUpdateType updateType) {
        super(mod, defaultProperties);
        if (unlocalizedTypeSuffix == null) {
            unlocalizedTypeSuffix = "";
        }
        this.unlocalizedTypeSuffix = unlocalizedTypeSuffix;
        this.updateType = updateType;
        if (MinecraftHelpers.isClientSide()) {
            this.registerModelResourceLocation();
        }
    }

    @Override
    public <P extends IPartType<P, S>, S extends IPartState<P>> void update(INetwork network, IPartNetwork partNetwork, P partType, PartTarget target, S state) {
        IAspectVariable variable = ((IPartTypeReader)partType).getVariable(target, (IPartStateReader)state, this);
        variable.invalidate();
    }

    @Override
    protected String getUnlocalizedType() {
        return "read" + this.unlocalizedTypeSuffix;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void registerModelResourceLocation() {
        Aspects.REGISTRY.registerAspectModel(this, ResourceLocation.parse((String)(this.getModId() + ":aspect/" + this.getUnlocalizedType().replaceAll("\\.", "/"))));
    }

    protected abstract V getValue(PartTarget var1, IAspectProperties var2) throws EvaluationException;

    @Override
    public IAspectVariable<V> createNewVariable(Supplier<PartTarget> target) {
        return new LazyAspectVariable<V>((IValueType)this.getValueType(), target, this){

            @Override
            public V getValueLazy() throws EvaluationException {
                return AspectReadBase.this.getValue(this.getTarget(), this.getAspectProperties());
            }
        };
    }

    @Override
    public AspectUpdateType getUpdateType() {
        return this.updateType;
    }
}

