/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.network.packet;

import com.mojang.text2speech.Narrator;
import java.util.Date;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.GeneralConfig;

public class SpeakTextPacket
extends PacketCodec {
    public static final CustomPacketPayload.Type<SpeakTextPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"integrateddynamics", (String)"speak_text"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SpeakTextPacket> CODEC = SpeakTextPacket.getCodec(SpeakTextPacket::new);
    public static long lastSay = 0L;
    @CodecField
    private String text;

    public SpeakTextPacket() {
        super(ID);
    }

    public SpeakTextPacket(String text) {
        super(ID);
        this.text = text;
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level world, Player player) {
        if (new Date().getTime() >= lastSay + (long)GeneralConfig.speachMaxFrequency) {
            Narrator.getNarrator().clear();
            Narrator.getNarrator().say(this.text, true);
            lastSay = new Date().getTime();
        }
    }

    public void actionServer(Level world, ServerPlayer player) {
    }
}

