/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.neoauth.impl.gui;

import com.mrbysco.neoauth.NeoAuth;
import com.mrbysco.neoauth.api.gui.AuthScreen;
import com.mrbysco.neoauth.util.MicrosoftUtils;
import com.mrbysco.neoauth.util.SessionUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.apache.http.conn.ConnectTimeoutException;

public class MicrosoftAuthScreen
extends AuthScreen {
    private ExecutorService executor = null;
    private CompletableFuture<Void> task = null;
    private StringWidget statusWidget = null;
    private final boolean selectAccount;

    public MicrosoftAuthScreen(Screen parentScreen, Screen successScreen, boolean selectAccount) {
        super((Component)Component.translatable((String)"gui.neo_auth.microsoft.title"), parentScreen, successScreen);
        this.selectAccount = selectAccount;
        this.closeOnSuccess = true;
    }

    @Override
    protected void init() {
        super.init();
        assert (this.minecraft != null);
        StringWidget titleWidget = new StringWidget(this.width, this.height, this.title, this.font);
        titleWidget.setColor(0xFFFFFF);
        titleWidget.setPosition(this.width / 2 - titleWidget.getWidth() / 2, this.height / 2 - titleWidget.getHeight() / 2 - 27);
        this.addRenderableWidget((GuiEventListener)titleWidget);
        this.statusWidget = new StringWidget(this.width, this.height, this.title, this.font);
        this.statusWidget.setColor(0xDDDDDD);
        this.statusWidget.setPosition(this.width / 2 - this.statusWidget.getWidth() / 2, this.height / 2 - this.statusWidget.getHeight() / 2 - 1);
        this.addRenderableWidget((GuiEventListener)this.statusWidget);
        Button cancelBtn = Button.builder((Component)Component.translatable((String)"gui.cancel"), button -> this.onClose()).bounds(this.width / 2 - 50, this.height / 2 + 22, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)cancelBtn);
        if (this.task != null) {
            return;
        }
        this.statusWidget.setMessage((Component)Component.translatable((String)"gui.neo_auth.microsoft.status.checkBrowser"));
        this.executor = Executors.newSingleThreadExecutor();
        this.task = ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)MicrosoftUtils.acquireMSAuthCode(success -> Component.translatable((String)"gui.neo_auth.microsoft.browser").getString(), this.executor, this.selectAccount ? MicrosoftUtils.MicrosoftPrompt.SELECT_ACCOUNT : null).thenComposeAsync(msAuthCode -> {
            this.statusWidget.setMessage((Component)Component.translatable((String)"gui.neo_auth.microsoft.status.msAccessToken"));
            return MicrosoftUtils.acquireMSAccessToken(msAuthCode, this.executor);
        })).thenComposeAsync(msAccessToken -> {
            this.statusWidget.setMessage((Component)Component.translatable((String)"gui.neo_auth.microsoft.status.xboxAccessToken"));
            return MicrosoftUtils.acquireXboxAccessToken(msAccessToken, this.executor);
        })).thenComposeAsync(xboxAccessToken -> {
            this.statusWidget.setMessage((Component)Component.translatable((String)"gui.neo_auth.microsoft.status.xboxXstsToken"));
            return MicrosoftUtils.acquireXboxXstsToken(xboxAccessToken, this.executor);
        })).thenComposeAsync(xboxXstsData -> {
            this.statusWidget.setMessage((Component)Component.translatable((String)"gui.neo_auth.microsoft.status.mcAccessToken"));
            return MicrosoftUtils.acquireMCAccessToken((String)xboxXstsData.get("Token"), (String)xboxXstsData.get("uhs"), this.executor);
        })).thenComposeAsync(mcToken -> {
            this.statusWidget.setMessage((Component)Component.translatable((String)"gui.neo_auth.microsoft.status.mcProfile"));
            return MicrosoftUtils.login(mcToken, this.executor);
        })).thenAccept(session -> {
            SessionUtils.setSession(session);
            SystemToast.add((ToastComponent)this.minecraft.getToasts(), (SystemToast.SystemToastId)SystemToast.SystemToastId.PERIODIC_NOTIFICATION, (Component)Component.translatable((String)"gui.neo_auth.toast.greeting", (Object[])new Object[]{Component.literal((String)session.getName())}), null);
            NeoAuth.LOGGER.info("Successfully logged in via Microsoft!");
            this.success = true;
        })).exceptionally(error -> {
            String key = error.getCause() instanceof ConnectTimeoutException ? "gui.neo_auth.error.timeout" : ("NOT_FOUND: Not Found".equals(error.getCause().getMessage()) ? "gui.neo_auth.error.notPurchased" : "gui.neo_auth.error.generic");
            this.statusWidget.setMessage((Component)Component.translatable((String)key).withStyle(ChatFormatting.RED));
            cancelBtn.setMessage((Component)Component.translatable((String)"gui.back"));
            return null;
        });
    }

    @Override
    public void onClose() {
        if (this.task != null && !this.task.isDone()) {
            this.task.cancel(true);
            this.executor.shutdownNow();
        }
        super.onClose();
    }
}

