/*
 * Decompiled with CFR 0.152.
 */
package net.manmaed.cottonly.datagenerators;

import java.util.concurrent.CompletableFuture;
import net.manmaed.cottonly.datagenerators.CottonBlockModelProvider;
import net.manmaed.cottonly.datagenerators.CottonBlockStateProvider;
import net.manmaed.cottonly.datagenerators.CottonDataMaps;
import net.manmaed.cottonly.datagenerators.CottonGlobalLootModifierProvider;
import net.manmaed.cottonly.datagenerators.CottonItemModelProvider;
import net.manmaed.cottonly.datagenerators.CottonLanguageProvider;
import net.manmaed.cottonly.datagenerators.CottonLootTables;
import net.manmaed.cottonly.datagenerators.CottonRecipeProvider;
import net.manmaed.cottonly.datagenerators.CottonTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="cottonly", bus=EventBusSubscriber.Bus.MOD)
public class CottonlyDataGeneration {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new CottonRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new CottonItemModelProvider(packOutput, fileHelper));
        generator.addProvider(true, (DataProvider)new CottonBlockModelProvider(packOutput, fileHelper));
        CottonTagsProvider.addTags(event);
        generator.addProvider(true, (DataProvider)new CottonGlobalLootModifierProvider(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new CottonLootTables(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new CottonBlockStateProvider(packOutput, fileHelper));
        CottonLanguageProvider.addTranslations(generator);
        generator.addProvider(true, (DataProvider)new CottonDataMaps(packOutput, lookupProvider));
    }
}

