/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.capabilities;

import com.direwolf20.justdirethings.common.blockentities.ExperienceHolderBE;
import com.direwolf20.justdirethings.setup.Registration;
import java.util.function.Predicate;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class ExperienceHolderFluidTank
extends FluidTank {
    private final ExperienceHolderBE experienceHolderBE;

    public ExperienceHolderFluidTank(ExperienceHolderBE experienceHolderBE, Predicate<FluidStack> validator) {
        super(Integer.MAX_VALUE, validator);
        this.experienceHolderBE = experienceHolderBE;
        this.fluid = new FluidStack((Fluid)Registration.XP_FLUID_SOURCE.get(), this.getFluidAmount());
    }

    public int getFluidAmount() {
        if (this.experienceHolderBE.exp > 0x6666666) {
            return Integer.MAX_VALUE;
        }
        return Math.min(this.experienceHolderBE.exp * 20, this.getCapacity());
    }

    public FluidStack getFluid() {
        return new FluidStack((Fluid)Registration.XP_FLUID_SOURCE.get(), this.getFluidAmount());
    }

    public int getCapacity() {
        return Integer.MAX_VALUE;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0;
        }
        if (action.simulate()) {
            if (this.fluid.isEmpty()) {
                return Math.min(this.capacity, resource.getAmount() - resource.getAmount() % 20);
            }
            return Math.min(this.capacity - this.getFluidAmount() - (this.capacity - this.getFluidAmount()) % 20, resource.getAmount() - resource.getAmount() % 20);
        }
        if (this.fluid.isEmpty()) {
            int returnAmt = resource.getAmount() - this.insertFluid(resource.getAmount());
            this.fluid = new FluidStack((Fluid)Registration.XP_FLUID_SOURCE.get(), returnAmt);
            this.onContentsChanged();
            return returnAmt;
        }
        int filled = resource.getAmount() - this.insertFluid(resource.getAmount());
        if (filled > 0) {
            this.onContentsChanged();
        }
        return filled;
    }

    public int insertFluid(int amt) {
        int remaining = this.experienceHolderBE.addExp(amt / 20);
        int excessFluid = amt % 20;
        return remaining * 20 + excessFluid;
    }

    public int extractFluid(int amt) {
        int expNeeded = amt / 20;
        int unAvailable = this.experienceHolderBE.subExp(expNeeded);
        return unAvailable * 20 + amt % 20;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !FluidStack.isSameFluidSameComponents((FluidStack)resource, (FluidStack)this.fluid)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int drained = maxDrain - maxDrain % 20;
        if (this.getFluidAmount() < drained) {
            drained = this.getFluidAmount();
        }
        FluidStack stack = this.fluid.copyWithAmount(drained);
        if (action.execute() && drained > 0) {
            this.extractFluid(drained);
            this.onContentsChanged();
        }
        return stack;
    }

    protected void onContentsChanged() {
        this.experienceHolderBE.markDirtyClient();
    }
}

