/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities;

import com.direwolf20.justdirethings.client.particles.itemparticle.ItemFlowParticleData;
import com.direwolf20.justdirethings.common.blockentities.basebe.AreaAffectingBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.RedstoneControlledBE;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.ExperienceUtils;
import com.direwolf20.justdirethings.util.MiscHelpers;
import com.direwolf20.justdirethings.util.interfacehelpers.AreaAffectingData;
import com.direwolf20.justdirethings.util.interfacehelpers.FilterData;
import com.direwolf20.justdirethings.util.interfacehelpers.RedstoneControlData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class ExperienceHolderBE
extends BaseMachineBE
implements AreaAffectingBE,
RedstoneControlledBE {
    protected BlockCapabilityCache<IFluidHandler, Direction> attachedTank;
    public FilterData filterData = new FilterData();
    public AreaAffectingData areaAffectingData = new AreaAffectingData(((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING)).getOpposite());
    public RedstoneControlData redstoneControlData = this.getDefaultRedstoneData();
    public int exp;
    public int targetExp;
    private Player currentPlayer;
    public boolean collectExp;
    public boolean ownerOnly;
    public boolean showParticles = true;

    public ExperienceHolderBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)Registration.ExperienceHolderBE.get(), pPos, pBlockState);
    }

    @Override
    public BlockEntity getBlockEntity() {
        return this;
    }

    @Override
    public RedstoneControlData getRedstoneControlData() {
        return this.redstoneControlData;
    }

    @Override
    public AreaAffectingData getAreaAffectingData() {
        return this.areaAffectingData;
    }

    public void changeSettings(Player player, int targetExp, boolean ownerOnly, boolean collectExp, boolean showParticles) {
        if (this.ownerOnly && !player.getUUID().equals(this.placedByUUID)) {
            return;
        }
        this.targetExp = targetExp;
        this.ownerOnly = ownerOnly;
        this.collectExp = collectExp;
        this.showParticles = showParticles;
        this.markDirtyClient();
    }

    public int addExp(int addition) {
        if (this.exp > Integer.MAX_VALUE - addition) {
            int remainingExp = addition - (Integer.MAX_VALUE - this.exp);
            this.exp = Integer.MAX_VALUE;
            return remainingExp;
        }
        this.exp += addition;
        return 0;
    }

    public int subExp(int subtraction) {
        int amtToRemove = Math.min(this.exp, subtraction);
        this.exp -= amtToRemove;
        return subtraction - amtToRemove;
    }

    public void storeExp(Player player, int levelChange) {
        if (this.ownerOnly && !player.getUUID().equals(this.placedByUUID)) {
            return;
        }
        if (levelChange == -1) {
            int totalExp = ExperienceUtils.getPlayerTotalExperience(player);
            int remaining = this.addExp(totalExp);
            player.giveExperiencePoints(-totalExp);
            player.giveExperienceLevels(-1);
            if (remaining > 0) {
                player.giveExperiencePoints(remaining);
            }
        } else if (levelChange > 0) {
            int remaining;
            int expRemoved;
            int expInCurrentLevel = (int)(player.experienceProgress * (float)player.getXpNeededForNextLevel());
            if (player.experienceProgress > 0.0f) {
                expRemoved = ExperienceUtils.removePoints(player, expInCurrentLevel);
                remaining = this.addExp(expRemoved);
                --levelChange;
                player.experienceProgress = 0.0f;
                if (remaining > 0) {
                    player.giveExperiencePoints(remaining);
                }
            }
            if (levelChange > 0 && (remaining = this.addExp(expRemoved = ExperienceUtils.removeLevels(player, levelChange))) > 0) {
                player.giveExperiencePoints(remaining);
            }
        }
        this.markDirtyClient();
    }

    public void extractExp(Player player, int levelChange) {
        if (this.exp == 0) {
            return;
        }
        if (this.ownerOnly && !player.getUUID().equals(this.placedByUUID)) {
            return;
        }
        if (levelChange == -1) {
            int expToGive = this.exp;
            player.giveExperiencePoints(expToGive);
            this.exp = 0;
        } else if (levelChange > 0) {
            if (this.roundUpToNextLevel(player)) {
                --levelChange;
            }
            if (levelChange > 0 && this.exp > 0) {
                int expForNextLevels = ExperienceUtils.getTotalExperienceForLevel(player.experienceLevel + levelChange) - ExperienceUtils.getPlayerTotalExperience(player);
                int expToGive = Math.min(this.exp, expForNextLevels);
                player.giveExperiencePoints(expToGive);
                this.exp -= expToGive;
                this.roundUpToNextLevel(player);
            }
        }
        this.markDirtyClient();
    }

    public boolean roundUpToNextLevel(Player player) {
        if (this.exp <= 0) {
            return false;
        }
        int expInCurrentLevel = (int)(player.experienceProgress * (float)player.getXpNeededForNextLevel());
        if (expInCurrentLevel > 0) {
            int expToGive = Math.min(this.exp, ExperienceUtils.getExpNeededForNextLevel(player));
            player.giveExperiencePoints(expToGive);
            this.exp -= expToGive;
            return true;
        }
        return false;
    }

    @Override
    public void tickClient() {
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.collectExp) {
            this.collectExp();
        }
        this.handleExperience();
    }

    public void doParticles(ItemStack itemStack, Vec3 sourcePos, boolean toBlock) {
        if (!this.showParticles) {
            return;
        }
        Direction direction = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING);
        BlockPos blockPos = this.getBlockPos();
        Vec3 baubleSpot = new Vec3((double)((float)blockPos.getX() + 0.5f) - 0.3 * (double)direction.getStepX(), (double)((float)blockPos.getY() + 0.5f) - 0.3 * (double)direction.getStepY(), (double)((float)blockPos.getZ() + 0.5f) - 0.3 * (double)direction.getStepZ());
        double d0 = sourcePos.x();
        double d1 = sourcePos.y();
        double d2 = sourcePos.z();
        if (toBlock) {
            ItemFlowParticleData data = new ItemFlowParticleData(itemStack, baubleSpot.x, baubleSpot.y, baubleSpot.z, 1);
            ((ServerLevel)this.level).sendParticles((ParticleOptions)data, d0, d1, d2, 10, 0.0, 0.0, 0.0, 0.0);
        } else {
            ItemFlowParticleData data = new ItemFlowParticleData(itemStack, d0, d1, d2, 1);
            ((ServerLevel)this.level).sendParticles((ParticleOptions)data, baubleSpot.x, baubleSpot.y, baubleSpot.z, 10, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void handleExperience() {
        assert (this.level != null);
        if (this.isActiveRedstone() && this.canRun() && this.currentPlayer == null) {
            this.findTargetPlayer();
        }
        if (this.currentPlayer == null) {
            return;
        }
        int currentLevel = this.currentPlayer.experienceLevel;
        if (currentLevel < this.targetExp && this.exp > 0) {
            this.extractExp(this.currentPlayer, 1);
            this.doParticles(new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE), this.currentPlayer.getEyePosition().subtract(0.0, 0.25, 0.0), false);
            if (this.exp == 0) {
                this.currentPlayer = null;
            }
        } else if (currentLevel > this.targetExp || currentLevel == this.targetExp && this.currentPlayer.experienceProgress > 0.01f) {
            this.storeExp(this.currentPlayer, 1);
            this.doParticles(new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE), this.currentPlayer.getEyePosition().subtract(0.0, 0.25, 0.0), true);
        } else {
            this.currentPlayer = null;
        }
    }

    private void collectExp() {
        if (this.operationTicks != 0) {
            return;
        }
        assert (this.level != null);
        AABB searchArea = this.getAABB(this.getBlockPos());
        List entityList = this.level.getEntitiesOfClass(ExperienceOrb.class, searchArea, entity -> true).stream().toList();
        if (entityList.isEmpty()) {
            return;
        }
        for (ExperienceOrb experienceOrb : entityList) {
            int orbValue = experienceOrb.getValue();
            this.addExp(orbValue);
            this.doParticles(new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE), experienceOrb.position(), true);
            experienceOrb.discard();
        }
        this.markDirtyClient();
    }

    private void findTargetPlayer() {
        assert (this.level != null);
        AABB searchArea = this.getAABB(this.getBlockPos());
        List entityList = this.level.getEntitiesOfClass(Player.class, searchArea, entity -> true).stream().toList();
        if (entityList.isEmpty()) {
            return;
        }
        for (Player player : entityList) {
            if (this.ownerOnly && !player.getUUID().equals(this.placedByUUID) || player.experienceLevel == this.targetExp && !(player.experienceProgress > 0.01f)) continue;
            this.currentPlayer = player;
            return;
        }
    }

    private IFluidHandler getAttachedTank() {
        if (this.attachedTank == null) {
            assert (this.level != null);
            BlockState state = this.level.getBlockState(this.getBlockPos());
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            BlockPos inventoryPos = this.getBlockPos().relative(facing);
            this.attachedTank = BlockCapabilityCache.create((BlockCapability)Capabilities.FluidHandler.BLOCK, (ServerLevel)((ServerLevel)this.level), (BlockPos)inventoryPos, (Object)facing.getOpposite());
        }
        return (IFluidHandler)this.attachedTank.getCapability();
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("exp", this.exp);
        tag.putInt("targetExp", this.targetExp);
        tag.putBoolean("collectExp", this.collectExp);
        tag.putBoolean("ownerOnly", this.ownerOnly);
        tag.putBoolean("showParticles", this.showParticles);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.exp = tag.getInt("exp");
        this.targetExp = tag.getInt("targetExp");
        this.collectExp = tag.getBoolean("collectExp");
        this.ownerOnly = tag.getBoolean("ownerOnly");
        this.showParticles = tag.getBoolean("showParticles");
    }

    @Override
    public AreaAffectingData getDefaultAreaData(AreaAffectingBE areaAffectingBE) {
        return areaAffectingBE.getDefaultAreaData(((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING)).getOpposite());
    }

    @Override
    public RedstoneControlData getDefaultRedstoneData() {
        return new RedstoneControlData(MiscHelpers.RedstoneMode.PULSE);
    }

    @Override
    public boolean isDefaultSettings() {
        if (!super.isDefaultSettings()) {
            return false;
        }
        if (this.exp != 0) {
            return false;
        }
        if (this.targetExp != 0) {
            return false;
        }
        if (this.collectExp) {
            return false;
        }
        return !this.ownerOnly;
    }
}

