/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.renderactions;

import com.direwolf20.justdirethings.client.particles.alwaysvisibleparticle.AlwaysVisibleParticleData;
import com.direwolf20.justdirethings.client.renderers.OurRenderTypes;
import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.util.MiscHelpers;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.Tags;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public class ThingFinder {
    public static long xRayStartTime;
    public static long blockParticlesStartTime;
    private static long lastBlockDrawTime;
    private static long lastEntityDrawTime;
    public static long entityParticlesStartTime;
    public static List<BlockPos> oreBlocksList;
    public static List<Entity> entityList;
    private static int sortCounter;
    private static final ByteBufferBuilder byteBufferBuilder;
    private static MeshData meshdata;
    private static MeshData.SortState sortState;
    private static final VertexBuffer vertexBuffer;
    private static final RenderType renderType;
    private static final RenderType xRayRender;
    private static BlockPos renderedAtPos;

    public static void render(RenderLevelStageEvent evt, Player player, ItemStack heldItemMain) {
        long currentTime;
        if ((System.currentTimeMillis() - xRayStartTime) / 1000L < 10L) {
            ThingFinder.drawVBO(evt, player);
        }
        if (!oreBlocksList.isEmpty()) {
            currentTime = System.currentTimeMillis();
            if (currentTime - blockParticlesStartTime < 10000L) {
                if (currentTime - lastBlockDrawTime >= 500L) {
                    ThingFinder.drawParticlesOre(evt, player);
                    lastBlockDrawTime = currentTime;
                }
            } else {
                oreBlocksList.clear();
            }
        }
        if (!entityList.isEmpty()) {
            currentTime = System.currentTimeMillis();
            if (currentTime - entityParticlesStartTime < 10000L) {
                if (currentTime - lastEntityDrawTime >= 500L) {
                    ThingFinder.discoverMobs(player, false);
                    ThingFinder.drawParticlesEntity(evt, player);
                    lastEntityDrawTime = currentTime;
                }
            } else {
                entityList.clear();
            }
        }
    }

    public static void discover(Player player, Ability toolAbility, ItemStack itemStack) {
        if (toolAbility.equals((Object)Ability.MOBSCANNER)) {
            ThingFinder.discoverMobs(player, true);
        } else if (toolAbility.equals((Object)Ability.ORESCANNER) || toolAbility.equals((Object)Ability.OREXRAY)) {
            ThingFinder.discoverOres(player, toolAbility, itemStack);
        }
    }

    private static void discoverOres(Player player, Ability toolAbility, ItemStack itemStack) {
        oreBlocksList.clear();
        BlockPos playerPos = player.getOnPos();
        int radius = 10;
        oreBlocksList = BlockPos.betweenClosedStream((BlockPos)playerPos.offset(-radius, -radius, -radius), (BlockPos)playerPos.offset(radius, radius, radius)).filter(blockPos -> ThingFinder.isValidBlock(blockPos, player, itemStack)).map(BlockPos::immutable).collect(Collectors.toList());
        if (toolAbility.equals((Object)Ability.OREXRAY)) {
            xRayStartTime = System.currentTimeMillis();
            ThingFinder.generateVBO(player);
        } else if (toolAbility.equals((Object)Ability.ORESCANNER)) {
            blockParticlesStartTime = System.currentTimeMillis();
        }
    }

    private static boolean isValidBlock(BlockPos blockPos, Player player, ItemStack itemStack) {
        BlockState blockState = player.level().getBlockState(blockPos);
        if (!blockState.getTags().anyMatch(tag -> tag.equals((Object)Tags.Blocks.ORES))) {
            return false;
        }
        Item item = itemStack.getItem();
        if (item instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            return itemStack.isCorrectToolForDrops(blockState);
        }
        return true;
    }

    private static void discoverMobs(Player player, boolean startTimer) {
        entityList.clear();
        BlockPos playerPos = player.getOnPos();
        int radius = 10;
        entityList = player.level().getEntities((Entity)player, AABB.encapsulatingFullBlocks((BlockPos)playerPos.offset(-radius, -radius, -radius), (BlockPos)playerPos.offset(radius, radius, radius))).stream().filter(entity -> entity instanceof Monster).collect(Collectors.toList());
        if (startTimer) {
            entityParticlesStartTime = System.currentTimeMillis();
        }
    }

    public static void drawParticlesOre(RenderLevelStageEvent evt, Player player) {
        Random random = new Random();
        Level level = player.level();
        AlwaysVisibleParticleData data = new AlwaysVisibleParticleData(BuiltInRegistries.PARTICLE_TYPE.getKey((Object)ParticleTypes.HAPPY_VILLAGER));
        for (int i = 0; i < 2; ++i) {
            for (BlockPos pos : oreBlocksList) {
                double d0 = (double)pos.getX() + random.nextDouble();
                double d1 = (double)pos.getY() + random.nextDouble();
                double d2 = (double)pos.getZ() + random.nextDouble();
                level.addParticle((ParticleOptions)data, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void drawParticlesEntity(RenderLevelStageEvent evt, Player player) {
        Level level = player.level();
        AlwaysVisibleParticleData data = new AlwaysVisibleParticleData(BuiltInRegistries.PARTICLE_TYPE.getKey((Object)ParticleTypes.SOUL));
        for (int i = 0; i < 5; ++i) {
            for (Entity entity : entityList) {
                AABB aabb = entity.getBoundingBox();
                double d0 = MiscHelpers.nextDouble(aabb.minX, aabb.maxX);
                double d1 = MiscHelpers.nextDouble(aabb.minY, aabb.maxY);
                double d2 = MiscHelpers.nextDouble(aabb.minZ, aabb.maxZ);
                level.addParticle((ParticleOptions)data, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void generateVBO(Player player) {
        if (oreBlocksList == null || oreBlocksList.isEmpty()) {
            return;
        }
        PoseStack matrix = new PoseStack();
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        ModelBlockRenderer modelBlockRenderer = dispatcher.getModelRenderer();
        RandomSource random = RandomSource.create();
        Level level = player.level();
        renderedAtPos = player.getOnPos();
        byteBufferBuilder.clear();
        BufferBuilder builder = new BufferBuilder(byteBufferBuilder, renderType.mode(), renderType.format());
        for (BlockPos pos : oreBlocksList) {
            BlockState renderState = level.getBlockState(pos);
            if (renderState.isAir()) continue;
            BakedModel ibakedmodel = dispatcher.getBlockModel(renderState);
            matrix.pushPose();
            matrix.translate((float)(-renderedAtPos.getX()), (float)(-renderedAtPos.getY()), (float)(-renderedAtPos.getZ()));
            matrix.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            float translateF = 5.0E-4f;
            matrix.translate(translateF, translateF, translateF);
            float scaleF = 0.001f;
            matrix.scale(1.0f - scaleF, 1.0f - scaleF, 1.0f - scaleF);
            for (RenderType renderTypeDraw : ibakedmodel.getRenderTypes(renderState, random, ModelData.EMPTY)) {
                try {
                    modelBlockRenderer.tesselateBlock((BlockAndTintGetter)level, ibakedmodel, renderState, pos.above(255), matrix, (VertexConsumer)builder, false, random, renderState.getSeed(pos), OverlayTexture.NO_OVERLAY, ibakedmodel.getModelData((BlockAndTintGetter)level, pos, renderState, ModelData.EMPTY), renderTypeDraw);
                }
                catch (Exception exception) {}
            }
            matrix.popPose();
        }
        Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        Vec3 subtracted = projectedView.subtract((double)renderedAtPos.getX(), (double)renderedAtPos.getY(), (double)renderedAtPos.getZ());
        Vector3f sortPos = new Vector3f((float)subtracted.x, (float)subtracted.y, (float)subtracted.z);
        if (meshdata != null) {
            meshdata.close();
        }
        if ((meshdata = builder.build()) != null) {
            sortState = meshdata.sortQuads(byteBufferBuilder, VertexSorting.byDistance((Vector3f)sortPos));
            vertexBuffer.bind();
            vertexBuffer.upload(meshdata);
            VertexBuffer.unbind();
        }
        oreBlocksList.clear();
    }

    public static void drawVBO(RenderLevelStageEvent evt, Player player) {
        if (vertexBuffer == null || oreBlocksList == null) {
            return;
        }
        Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        BlockPos currentPos = player.getOnPos();
        BlockPos renderPos = new BlockPos(currentPos.getX() - (currentPos.getX() - renderedAtPos.getX()), currentPos.getY() - (currentPos.getY() - renderedAtPos.getY()), currentPos.getZ() - (currentPos.getZ() - renderedAtPos.getZ()));
        if (sortCounter > 20) {
            if (sortState != null) {
                ThingFinder.sortAll(renderPos);
            }
            sortCounter = 0;
        } else {
            ++sortCounter;
        }
        PoseStack matrix = evt.getPoseStack();
        matrix.pushPose();
        matrix.mulPose(evt.getModelViewMatrix());
        matrix.translate(-projectedView.x(), -projectedView.y(), -projectedView.z());
        matrix.translate((float)renderPos.getX(), (float)renderPos.getY(), (float)renderPos.getZ());
        try {
            if (vertexBuffer.getFormat() == null) {
                return;
            }
            xRayRender.setupRenderState();
            vertexBuffer.bind();
            vertexBuffer.drawWithShader(matrix.last().pose(), new Matrix4f((Matrix4fc)evt.getProjectionMatrix()), RenderSystem.getShader());
            VertexBuffer.unbind();
            xRayRender.clearRenderState();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        matrix.popPose();
    }

    public static void sortAll(BlockPos lookingAt) {
        ByteBufferBuilder.Result sortResult = ThingFinder.sort(lookingAt);
        vertexBuffer.bind();
        vertexBuffer.uploadIndexBuffer(sortResult);
        VertexBuffer.unbind();
    }

    public static ByteBufferBuilder.Result sort(BlockPos lookingAt) {
        Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        Vec3 subtracted = projectedView.subtract((double)lookingAt.getX(), (double)lookingAt.getY(), (double)lookingAt.getZ());
        Vector3f sortPos = new Vector3f((float)subtracted.x, (float)subtracted.y, (float)subtracted.z);
        return sortState.buildSortedIndexBuffer(byteBufferBuilder, VertexSorting.byDistance((Vector3f)sortPos));
    }

    static {
        lastBlockDrawTime = 0L;
        lastEntityDrawTime = 0L;
        oreBlocksList = new ArrayList<BlockPos>();
        entityList = new ArrayList<Entity>();
        sortCounter = 0;
        byteBufferBuilder = new ByteBufferBuilder(RenderType.cutout().bufferSize());
        vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        renderType = RenderType.translucent();
        xRayRender = OurRenderTypes.OreXRAY;
        renderedAtPos = BlockPos.ZERO;
    }
}

