/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.jei;

import com.direwolf20.justdirethings.datagen.recipes.GooSpreadRecipeTag;
import com.direwolf20.justdirethings.setup.Registration;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.crafting.BlockTagIngredient;

public class GooSpreadRecipeTagCategory
implements IRecipeCategory<GooSpreadRecipeTag> {
    public static final RecipeType<GooSpreadRecipeTag> TYPE = RecipeType.create((String)"justdirethings", (String)"goo_spread_recipe_tag", GooSpreadRecipeTag.class);
    public static final int width = 120;
    public static final int height = 40;
    private final IDrawable background;
    private final IDrawable slot;
    private final IDrawable icon;
    private final Component localizedName;
    private final IDrawableStatic arrow;

    public GooSpreadRecipeTagCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(120, 40);
        this.slot = guiHelper.getSlotDrawable();
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)Registration.GooBlock_Tier1.get()));
        this.localizedName = Component.translatable((String)"justdirethings.goospreadrecipetag.title");
        this.arrow = guiHelper.getRecipeArrow();
    }

    public RecipeType<GooSpreadRecipeTag> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(GooSpreadRecipeTag recipe, IRecipeSlotsView slotsView, GuiGraphics gui, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.arrow.draw(gui, 54, 12);
        this.background.draw(gui, 17, 0);
        RenderSystem.disableBlend();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GooSpreadRecipeTag recipe, IFocusGroup focuses) {
        BlockTagIngredient input = recipe.getInput();
        IRecipeSlotBuilder inputSlotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, 9, 12);
        List itemstacks = input.getItems().toList();
        inputSlotBuilder.addItemStacks(itemstacks);
        ArrayList<ItemStack> catalystlist = new ArrayList<ItemStack>();
        if (recipe.getTierRequirement() <= 1) {
            catalystlist.add(new ItemStack((ItemLike)Registration.GooBlock_Tier1.get()));
        }
        if (recipe.getTierRequirement() <= 2) {
            catalystlist.add(new ItemStack((ItemLike)Registration.GooBlock_Tier2.get()));
        }
        if (recipe.getTierRequirement() <= 3) {
            catalystlist.add(new ItemStack((ItemLike)Registration.GooBlock_Tier3.get()));
        }
        if (recipe.getTierRequirement() <= 4) {
            catalystlist.add(new ItemStack((ItemLike)Registration.GooBlock_Tier4.get()));
        }
        builder.addSlot(RecipeIngredientRole.CATALYST, 29, 12).addItemStacks(catalystlist);
        BlockState output = recipe.getOutput();
        if (output.getBlock().asItem() != Items.AIR) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 88, 12).addItemStack(new ItemStack((ItemLike)output.getBlock()));
        } else {
            Block block = output.getBlock();
            if (block instanceof LiquidBlock) {
                LiquidBlock liquidBlock = (LiquidBlock)block;
                builder.addSlot(RecipeIngredientRole.OUTPUT, 88, 12).addFluidStack((Fluid)liquidBlock.fluid, 1000L);
            }
        }
    }
}

