/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.entityrenders;

import com.direwolf20.justdirethings.client.entitymodels.PortalProjectileModel;
import com.direwolf20.justdirethings.common.entities.PortalProjectile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class PortalProjectileRender
extends EntityRenderer<PortalProjectile> {
    protected static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/entity/portal_projectile.png");
    protected final PortalProjectileModel model;

    public PortalProjectileRender(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = new PortalProjectileModel(pContext.bakeLayer(PortalProjectileModel.Portal_Projectile_Layer));
    }

    public void render(PortalProjectile pEntity, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        pPoseStack.pushPose();
        float f = Mth.rotLerp((float)pPartialTicks, (float)pEntity.yRotO, (float)pEntity.getYRot());
        float f1 = Mth.lerp((float)pPartialTicks, (float)pEntity.xRotO, (float)pEntity.getXRot());
        float f2 = (float)pEntity.tickCount + pPartialTicks;
        pPoseStack.translate(0.0, (double)0.15f, 0.0);
        pPoseStack.mulPose(Axis.YP.rotationDegrees(Mth.sin((float)(f2 * 0.1f)) * 180.0f));
        pPoseStack.mulPose(Axis.XP.rotationDegrees(Mth.cos((float)(f2 * 0.1f)) * 180.0f));
        pPoseStack.mulPose(Axis.ZP.rotationDegrees(Mth.sin((float)(f2 * 0.15f)) * 360.0f));
        pPoseStack.scale(0.5f, 0.5f, 0.5f);
        this.model.setupAnim(pEntity, 0.0f, 0.0f, 0.0f, f, f1);
        VertexConsumer vertexconsumer = pBuffer.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)TEXTURE));
        this.model.renderToBuffer(pPoseStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY);
        pPoseStack.popPose();
        super.render((Entity)pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
    }

    public ResourceLocation getTextureLocation(PortalProjectile pEntity) {
        return TEXTURE;
    }
}

