/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.entityrenders;

import com.direwolf20.justdirethings.client.renderers.RenderHelpers;
import com.direwolf20.justdirethings.client.renderers.shader.DireRenderTypes;
import com.direwolf20.justdirethings.client.renderers.shader.ShaderTexture;
import com.direwolf20.justdirethings.common.entities.PortalEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class PortalEntityRender<T extends PortalEntity>
extends EntityRenderer<T> {
    protected static final RenderType renderType = DireRenderTypes.getRenderType("portal_entity").using(List.of(new ShaderTexture(ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/block/portal_shader.png"))));

    public PortalEntityRender(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public void render(T pEntity, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        float progress;
        pPoseStack.pushPose();
        float startValue = 0.0f;
        float endValueStart = -0.5f;
        float endValueEnd = 0.5f;
        float startValue2 = 1.0f;
        float endValueStart2 = 0.0f;
        float endValueEnd2 = 2.0f;
        int maxTicks = PortalEntity.ANIMATION_COOLDOWN;
        int currentTick = ((PortalEntity)((Object)pEntity)).tickCount;
        if (((PortalEntity)((Object)pEntity)).isDying()) {
            int deathCounter = ((PortalEntity)((Object)pEntity)).getDeathCounter();
            float deathTicks = (float)deathCounter + pPartialTicks;
            progress = ((float)maxTicks - Math.min(deathTicks, (float)maxTicks)) / (float)maxTicks;
        } else {
            float totalTicks = (float)currentTick + pPartialTicks;
            progress = Math.min(totalTicks / (float)maxTicks, 1.0f);
        }
        float interpolatedStart = startValue + (endValueStart - startValue) * progress;
        float interpolatedEnd = startValue + (endValueEnd - startValue) * progress;
        float start = interpolatedStart;
        float end = interpolatedEnd;
        float interpolatedStart2 = startValue2 + (endValueStart2 - startValue2) * progress;
        float interpolatedEnd2 = startValue2 + (endValueEnd2 - startValue2) * progress;
        float start2 = interpolatedStart2;
        float end2 = interpolatedEnd2;
        VertexConsumer vertexConsumer = pBuffer.getBuffer(renderType);
        Direction direction = ((PortalEntity)((Object)pEntity)).getDirection();
        Direction.Axis alignment = ((PortalEntity)((Object)pEntity)).getAlignment();
        AABB renderBounds = pEntity.getBoundingBox().move(-pEntity.getX(), -pEntity.getY(), -pEntity.getZ());
        Vector3f renderSpots = new Vector3f(renderBounds.getXsize() < 0.5 ? 0.0f : (float)renderBounds.getXsize(), renderBounds.getYsize() < 0.5 ? 0.0f : (float)renderBounds.getYsize(), renderBounds.getZsize() < 0.5 ? 0.0f : (float)renderBounds.getZsize());
        if (direction.getAxis() == Direction.Axis.Z) {
            this.renderFace(pPoseStack.last().pose(), vertexConsumer, start, end, start2, end2, 0.0f, 0.0f, 0.0f, 0.0f);
            this.renderFace(pPoseStack.last().pose(), vertexConsumer, start, end, end2, start2, 0.0f, 0.0f, 0.0f, 0.0f);
        } else if (direction.getAxis() == Direction.Axis.X) {
            this.renderFace(pPoseStack.last().pose(), vertexConsumer, 0.0f, 0.0f, end2, start2, start, end, end, start);
            this.renderFace(pPoseStack.last().pose(), vertexConsumer, 0.0f, 0.0f, start2, end2, start, end, end, start);
        } else if (alignment == Direction.Axis.X) {
            this.renderFace(pPoseStack.last().pose(), vertexConsumer, start2, end2, 0.0f, 0.0f, start, start, end, end);
            this.renderFace(pPoseStack.last().pose(), vertexConsumer, start2, end2, 0.0f, 0.0f, end, end, start, start);
        } else {
            this.renderFace(pPoseStack.last().pose(), vertexConsumer, start, end, 0.0f, 0.0f, start2, start2, end2, end2);
            this.renderFace(pPoseStack.last().pose(), vertexConsumer, start, end, 0.0f, 0.0f, end2, end2, start2, start2);
        }
        Color lightBlue = new Color(0, 153, 255, 255);
        Color orangePortalColor = new Color(255, 165, 0, 255);
        Color color = ((PortalEntity)((Object)pEntity)).getIsPrimary() ? lightBlue : orangePortalColor;
        this.renderFlatFrame(pPoseStack, pBuffer, renderBounds, 0.025f, color, direction.getAxis());
        pPoseStack.popPose();
        super.render(pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
    }

    private void renderFlatFrame(PoseStack matrix, MultiBufferSource buffer, AABB aabb, float thickness, Color color, Direction.Axis alignment) {
        float minX = (float)aabb.minX;
        float minY = (float)aabb.minY;
        float minZ = (float)aabb.minZ;
        float maxX = (float)aabb.maxX;
        float maxY = (float)aabb.maxY;
        float maxZ = (float)aabb.maxZ;
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float alpha = (float)color.getAlpha() / 255.0f;
        if (alignment == Direction.Axis.Z) {
            RenderHelpers.renderBoxSolid(matrix, matrix.last().pose(), buffer, new AABB((double)minX, (double)minY, (double)((minZ + maxZ) / 2.0f), (double)(minX + thickness), (double)maxY, (double)((minZ + maxZ) / 2.0f)), r, g, b, alpha);
            RenderHelpers.renderBoxSolid(matrix, matrix.last().pose(), buffer, new AABB((double)(maxX - thickness), (double)minY, (double)((minZ + maxZ) / 2.0f), (double)maxX, (double)maxY, (double)((minZ + maxZ) / 2.0f)), r, g, b, alpha);
            RenderHelpers.renderBoxSolid(matrix, matrix.last().pose(), buffer, new AABB((double)minX, (double)minY, (double)((minZ + maxZ) / 2.0f), (double)maxX, (double)(minY + thickness), (double)((minZ + maxZ) / 2.0f)), r, g, b, alpha);
            RenderHelpers.renderBoxSolid(matrix, matrix.last().pose(), buffer, new AABB((double)minX, (double)(maxY - thickness), (double)((minZ + maxZ) / 2.0f), (double)maxX, (double)maxY, (double)((minZ + maxZ) / 2.0f)), r, g, b, alpha);
        } else if (alignment == Direction.Axis.X) {
            RenderHelpers.renderBoxSolid(matrix, matrix.last().pose(), buffer, new AABB((double)((minX + maxX) / 2.0f), (double)minY, (double)minZ, (double)((minX + maxX) / 2.0f), (double)maxY, (double)(minZ + thickness)), r, g, b, alpha);
            RenderHelpers.renderBoxSolid(matrix, matrix.last().pose(), buffer, new AABB((double)((minX + maxX) / 2.0f), (double)minY, (double)(maxZ - thickness), (double)((minX + maxX) / 2.0f), (double)maxY, (double)maxZ), r, g, b, alpha);
            RenderHelpers.renderBoxSolid(matrix, matrix.last().pose(), buffer, new AABB((double)((minX + maxX) / 2.0f), (double)minY, (double)minZ, (double)((minX + maxX) / 2.0f), (double)(minY + thickness), (double)maxZ), r, g, b, alpha);
            RenderHelpers.renderBoxSolid(matrix, matrix.last().pose(), buffer, new AABB((double)((minX + maxX) / 2.0f), (double)(maxY - thickness), (double)minZ, (double)((minX + maxX) / 2.0f), (double)maxY, (double)maxZ), r, g, b, alpha);
        } else {
            RenderHelpers.renderBoxSolid(matrix, matrix.last().pose(), buffer, new AABB((double)minX, (double)minY, (double)minZ, (double)(minX + thickness), (double)minY, (double)maxZ), r, g, b, alpha);
            RenderHelpers.renderBoxSolid(matrix, matrix.last().pose(), buffer, new AABB((double)(maxX - thickness), (double)minY, (double)minZ, (double)maxX, (double)minY, (double)maxZ), r, g, b, alpha);
            RenderHelpers.renderBoxSolid(matrix, matrix.last().pose(), buffer, new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)minY, (double)(minZ + thickness)), r, g, b, alpha);
            RenderHelpers.renderBoxSolid(matrix, matrix.last().pose(), buffer, new AABB((double)minX, (double)minY, (double)(maxZ - thickness), (double)maxX, (double)minY, (double)maxZ), r, g, b, alpha);
        }
    }

    public ResourceLocation getTextureLocation(T pEntity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    private void renderFace(Matrix4f matrixStack, VertexConsumer vertexConsumer, float x1, float x2, float y1, float y2, float z1, float z2, float z3, float z4) {
        vertexConsumer.addVertex(matrixStack, x1, y1, z1).setUv(0.0f, 0.0f);
        vertexConsumer.addVertex(matrixStack, x2, y1, z2).setUv(1.0f, 0.0f);
        vertexConsumer.addVertex(matrixStack, x2, y2, z3).setUv(1.0f, 1.0f);
        vertexConsumer.addVertex(matrixStack, x1, y2, z4).setUv(0.0f, 1.0f);
    }
}

