/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.feature.common.mods.minecraft;

import dev.uncandango.alltheleaks.annotation.Issue;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.fml.loading.LoadingModList;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@Issue(modId="minecraft", issueId="Ingredient Deduplication", versionRange="1.21.1", mixins={"main.IngredientMixin", "main.IngredientMixin$IngredientAccessor"}, config="ingredientDedupe", configActivated=false)
public class IngredientDedupe
implements PreparableReloadListener {
    private static final ObjectOpenCustomHashSet<Ingredient> INGREDIENT_CACHE;
    public static IngredientDedupe INSTANCE;
    private static final boolean MODERNFIX_DEDUPLICATION;

    public static IngredientDedupe getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new IngredientDedupe();
        }
        return INSTANCE;
    }

    public static synchronized Ingredient intern(Ingredient ingredient) {
        return (Ingredient)INGREDIENT_CACHE.addOrGet((Object)ingredient);
    }

    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return CompletableFuture.runAsync(() -> INGREDIENT_CACHE.clear(), backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).wait(arg_0));
    }

    public String getName() {
        return "atl_ingredient_dedupe";
    }

    static {
        Hash.Strategy<Ingredient> BASIC_HASH_STRATEGY = new Hash.Strategy<Ingredient>(){

            public int hashCode(Ingredient o) {
                if (o == null) {
                    return 0;
                }
                int result = 1;
                for (Ingredient.Value element : o.getValues()) {
                    Ingredient.ItemValue iv;
                    result = element instanceof Ingredient.ItemValue ? (31 * result + ItemStackLinkedSet.TYPE_AND_TAG.hashCode((Object)(iv = (Ingredient.ItemValue)element).item()) + iv.item().getCount() > 1 ? iv.item().getCount() : 0) : 31 * result + (element == null ? 0 : element.hashCode());
                }
                return result;
            }

            /*
             * Loose catch block
             */
            public boolean equals(Ingredient a, Ingredient b) {
                Ingredient.Value[] bValues;
                if (b == null) {
                    return false;
                }
                Ingredient.Value[] aValues = a.getValues();
                if (aValues.length != (bValues = b.getValues()).length) {
                    return false;
                }
                for (int i = 0; i < aValues.length; ++i) {
                    Ingredient.Value aValue = aValues[i];
                    Ingredient.Value bValue = bValues[i];
                    if (aValue.getClass() != bValue.getClass()) {
                        return false;
                    }
                    if (aValue instanceof Ingredient.TagValue && bValue instanceof Ingredient.TagValue) {
                        if (aValue.equals((Object)bValue)) continue;
                        return false;
                    }
                    if (aValue instanceof Ingredient.ItemValue) {
                        ItemStack itemStack;
                        Ingredient.ItemValue itemValue = (Ingredient.ItemValue)aValue;
                        ItemStack item = itemStack = itemValue.item();
                        if (bValue instanceof Ingredient.ItemValue) {
                            Ingredient.ItemValue itemValue2 = (Ingredient.ItemValue)bValue;
                            ItemStack item1 = itemStack = itemValue2.item();
                            if (!(MODERNFIX_DEDUPLICATION ? aValue != bValue : item.getCount() != item1.getCount() || !ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)item1))) continue;
                            return false;
                        }
                    }
                    return false;
                }
                return true;
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        };
        INGREDIENT_CACHE = new ObjectOpenCustomHashSet((Hash.Strategy)BASIC_HASH_STRATEGY);
        MODERNFIX_DEDUPLICATION = LoadingModList.get().getModFileById("modernfix") != null ? ModernFixMixinPlugin.instance.isOptionEnabled("perf.ingredient_item_deduplication.IngredientMixin") : false;
    }
}

