/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.commands;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.sun.management.HotSpotDiagnosticMXBean;
import dev.uncandango.alltheleaks.AllTheLeaks;
import dev.uncandango.alltheleaks.api.windows.PsApi;
import dev.uncandango.alltheleaks.config.ATLProperties;
import dev.uncandango.alltheleaks.diag.common.mods.minecraft.DebugNativeImage;
import dev.uncandango.alltheleaks.utils.MemoryStats;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryUtil;

public final class ATLCommands {
    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"atl").then(Commands.literal((String)"run_full_gc").executes(cmd -> ATLCommands.runGc((CommandSourceStack)cmd.getSource())))).then(Commands.literal((String)"clear_native_images").executes(cmd -> ATLCommands.clearNativeImages((CommandSourceStack)cmd.getSource()))));
    }

    private static int clearNativeImages(CommandSourceStack source) {
        if (!ATLProperties.get().debugNativeImage) {
            source.sendFailure((Component)Component.literal((String)"DebugNativeImage is disabled, activate it at config/alltheleaks.json"));
            return 0;
        }
        AtomicInteger counter = new AtomicInteger();
        DebugNativeImage.NATIVE_IMAGES_TRACKER.forEach((k, v) -> {
            Set setWithEmptyRef = Collections.synchronizedSet(new HashSet());
            v.forEach(wr -> {
                NativeImage ref = (NativeImage)wr.imageRef().get();
                if (ref == null) {
                    setWithEmptyRef.add(wr);
                }
            });
            if (!v.isEmpty() && setWithEmptyRef.size() == v.size()) {
                AllTheLeaks.LOGGER.info("Removed all NativeImages for key {}", k);
                if (k.useStbFree()) {
                    STBImage.nstbi_image_free((long)k.pixels());
                } else {
                    MemoryUtil.nmemFree((long)k.pixels());
                }
                setWithEmptyRef.forEach(wr -> {
                    counter.getAndIncrement();
                    AllTheLeaks.LOGGER.info("Printing stack trace for: {}", (Object)wr.description());
                    boolean reachedInit = false;
                    for (StackTraceElement trace : wr.stackTraceElements()) {
                        if (!reachedInit) {
                            reachedInit = trace.getMethodName().contains("init");
                        }
                        if (!reachedInit) continue;
                        System.out.println("\tat " + trace.getClassName() + "." + trace.getMethodName() + "(" + trace.getFileName() + ":" + trace.getLineNumber() + ")");
                    }
                });
                v.clear();
            }
        });
        source.sendSuccess(() -> Component.literal((String)("Cleared " + counter.get() + " NativeImages")), true);
        return 1;
    }

    public static int runGc(CommandSourceStack source) {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            HotSpotDiagnosticMXBean hotSpotDiagnosticMXBean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
            boolean gcDisabled = Boolean.parseBoolean(hotSpotDiagnosticMXBean.getVMOption("DisableExplicitGC").getValue());
            if (gcDisabled) {
                source.sendFailure((Component)Component.literal((String)"Explicit GC is disabled, remove arguments -XX:+DisableExplicitGC"));
                return 0;
            }
        }
        catch (Exception e) {
            AllTheLeaks.LOGGER.error("Error while instancing MXBean: {}", (Object)e.getMessage());
            return 0;
        }
        System.gc();
        if (MemoryStats.ENABLED) {
            PsApi.EmptyWorkingSetOfCurrentProcess();
        }
        return 1;
    }
}

