/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.promoter.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.promoter.api.InfoFetcher;
import dev.ftb.mods.promoter.api.PromoData;
import dev.ftb.mods.promoter.screen.AdScreen;
import dev.ftb.mods.promoter.screen.RemoteTexture;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import org.jetbrains.annotations.Nullable;

public class ScreenInitEvent {
    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        if (!(event.getScreen() instanceof JoinMultiplayerScreen)) {
            return;
        }
        for (GuiEventListener guiEventListener : event.getListenersList()) {
            if (!(guiEventListener instanceof ServerSelectionList)) continue;
            ServerSelectionList selectionList = (ServerSelectionList)guiEventListener;
            for (ServerSelectionList.Entry child : selectionList.children()) {
                if (!(child instanceof ServerPromotionEntry)) continue;
                return;
            }
            if (InfoFetcher.get().getPromotions().isEmpty()) {
                return;
            }
            selectionList.children().addFirst(new ServerPromotionEntry(event.getScreen()));
        }
    }

    public static boolean renderAnnouncement(GuiGraphics graphics, int x, int y, int width, String announcement, @Nullable List<Component> tooltipLines, int mouseX, int mouseY, boolean offset) {
        boolean isOnlyPromo;
        boolean bl = isOnlyPromo = InfoFetcher.get().getPromotions().size() == 1;
        if (isOnlyPromo && offset) {
            x -= 74;
        }
        announcement = announcement.toUpperCase();
        Font font = Minecraft.getInstance().font;
        int textWidth = font.width(announcement);
        float textX = (float)(x + width) - (float)textWidth * 0.6f - 12.0f;
        int textY = y - 2;
        int borderSize = 1;
        int paddingX = 3;
        int paddingY = 2;
        int textHeight = 8;
        PoseStack pose = graphics.pose();
        pose.pushPose();
        pose.translate(textX, (float)textY, 100.0f);
        pose.scale(0.6f, 0.6f, 0.6f);
        graphics.fill(-paddingX - borderSize, -paddingY - borderSize, textWidth + paddingX + borderSize, textHeight + paddingY + borderSize, -2137632222);
        graphics.fill(-paddingX, -paddingY, textWidth + paddingX, textHeight + paddingY, -1144769);
        graphics.drawString(font, announcement, 0, 0, 0xFFFFFF);
        pose.popPose();
        boolean overAnnouncement = false;
        if (tooltipLines != null && !tooltipLines.isEmpty() && (float)mouseX >= textX - (float)paddingX && (float)mouseX <= textX + (float)(textWidth + paddingX * 2) * 0.6f && mouseY >= textY && mouseY <= textY + textHeight) {
            overAnnouncement = true;
            graphics.renderTooltip(font, tooltipLines, Optional.empty(), mouseX, mouseY + 10);
        }
        return overAnnouncement;
    }

    private static class ServerPromotionEntry
    extends ServerSelectionList.LANHeader {
        final List<EntryOption> options = new ArrayList<EntryOption>();
        private final Screen parent;

        public ServerPromotionEntry(Screen screen) {
            this.parent = screen;
            List<PromoData> promotions = InfoFetcher.get().getPromotions();
            if (promotions.isEmpty()) {
                return;
            }
            for (PromoData promotion : promotions.subList(0, Math.min(2, promotions.size()))) {
                this.options.add(new EntryOption(this, promotion, new RemoteTexture(URI.create(promotion.logo()), promotion.uuid().toString() + promotion.logoVersion(), Minecraft.getInstance().getTextureManager())));
            }
        }

        public Component getNarration() {
            return Component.empty();
        }

        public boolean mouseClicked(double p_331676_, double p_330254_, int p_331536_) {
            Minecraft.getInstance().setScreen((Screen)new AdScreen(this.parent));
            return false;
        }

        public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            int halfWidth = width / 2;
            if (this.isMouseOver(mouseX, mouseY)) {
                guiGraphics.fill(left - 2, top, left + width - 4, top + height, 0x30FFFFFF);
            }
            int leftOffset = 0;
            for (EntryOption option : this.options) {
                option.render(guiGraphics, left + leftOffset, top, mouseX, mouseY, this.options.size() == 1 ? width : halfWidth, height);
                leftOffset += halfWidth;
            }
        }
    }

    private static final class EntryOption {
        private final ServerPromotionEntry parent;
        private final PromoData data;
        private final RemoteTexture texture;
        private final List<Component> entryTooltipLines;
        private final List<Component> announcementTooltipLines;

        private EntryOption(ServerPromotionEntry parent, PromoData data, RemoteTexture texture) {
            this.parent = parent;
            this.data = data;
            this.texture = texture;
            this.announcementTooltipLines = this.createTooltipLines(data.announcementTooltip());
            this.entryTooltipLines = this.createTooltipLines(data.tooltip());
        }

        private List<Component> createTooltipLines(@Nullable String tooltip) {
            if (tooltip == null || tooltip.isEmpty()) {
                return Collections.emptyList();
            }
            String[] lines = tooltip.split("\n");
            ArrayList<Component> components = new ArrayList<Component>();
            for (String line : lines) {
                components.add((Component)Component.literal((String)line));
            }
            return components;
        }

        public void render(GuiGraphics graphics, int x, int y, int mouseX, int mouseY, int width, int height) {
            graphics.drawString(Minecraft.getInstance().font, this.data.name(), x + 35, y + 2, 0xFFFFFF);
            if (this.data.lineOneSubtitle() != null && !this.data.lineOneSubtitle().isEmpty()) {
                PoseStack pose = graphics.pose();
                pose.pushPose();
                pose.translate((float)(x + 35), (float)(y + 14), 0.0f);
                pose.scale(0.75f, 0.75f, 0.75f);
                graphics.drawString(Minecraft.getInstance().font, this.data.lineOneSubtitle(), 0, 0, -1291845633);
                if (this.data.lineTwoSubtitle() != null && !this.data.lineTwoSubtitle().isEmpty()) {
                    pose.translate(0.0f, 12.0f, 0.0f);
                    graphics.drawString(Minecraft.getInstance().font, this.data.lineTwoSubtitle(), 0, 0, -1291845633);
                }
                pose.popPose();
            }
            graphics.blit(this.texture.getTextureLocation(), x, y + 1, 0.0f, 0.0f, 30, 30, 30, 30);
            boolean overAnnouncement = false;
            if (this.data.announcement() != null && !this.data.announcement().isEmpty()) {
                overAnnouncement = ScreenInitEvent.renderAnnouncement(graphics, x, y, width, this.data.announcement(), this.announcementTooltipLines, mouseX, mouseY, false);
            }
            if (!this.entryTooltipLines.isEmpty() && !overAnnouncement && mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height) {
                graphics.renderTooltip(Minecraft.getInstance().font, this.entryTooltipLines, Optional.empty(), mouseX, mouseY + 10);
            }
        }
    }
}

