/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.variable;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.variable.VariableHolder;

public class VariableStorage {
    private final Map<String, Object> contents = new ConcurrentHashMap<String, Object>();

    public VariableStorage() {
        RocketClientMod.getInstance().getGlobalVariables().populate(this);
    }

    public VariableStorage(Map<String, Object> objects) {
        this();
        this.contents.putAll(objects);
    }

    public VariableStorage(VariableHolder holder) {
        this();
        this.store("id", holder.getId());
        Map<String, Object> variables = holder.getVariables();
        if (variables == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            this.store(entry.getKey(), entry.getValue());
        }
    }

    public void store(String key, Object value) {
        if (value == null) {
            this.contents.remove(key);
        } else {
            this.contents.put(key, value);
        }
    }

    public Map<String, Object> getContents() {
        return this.contents;
    }

    public <T> T retrieve(String key) {
        return (T)this.contents.get(key);
    }

    public void remove(String key) {
        this.contents.remove(key);
    }

    public boolean contains(String key) {
        return this.contents.containsKey(key);
    }

    public void inherit(VariableStorage storage, boolean override) {
        for (Map.Entry<String, Object> entry : storage.contents.entrySet()) {
            if (!override && this.contents.containsKey(entry.getKey())) continue;
            this.contents.put(entry.getKey(), entry.getValue());
        }
    }
}

