/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.element.type;

import com.google.gson.annotations.SerializedName;
import dev.ftb.mods.ftblibrary.ui.TextBox;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import net.minecraft.client.gui.GuiGraphics;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.element.WidgetElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableProcessor;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.joml.Vector2i;

public class TextBoxTemplate
extends WidgetElementTemplate {
    private static final String WIDTH_KEY = "width";
    private static final String HEIGHT_KEY = "height";
    private static final int DEFAULT_WIDTH = 150;
    private static final int DEFAULT_HEIGHT = 20;
    @SerializedName(value="character_limit")
    private Integer characterLimit;
    @SerializedName(value="variable_id")
    private String variableId;
    @SerializedName(value="default_text")
    private String defaultText;
    @SerializedName(value="numbers_only")
    private boolean numbersOnly;

    public TextBoxTemplate(String type, String id, ElementTemplate.Position position, ElementCallback callback) {
        super(type, id, position, callback);
    }

    public int getWidth() {
        return this.getOption(WIDTH_KEY, 150);
    }

    public int getHeight() {
        return this.getOption(HEIGHT_KEY, 20);
    }

    @Override
    public Widget createElement0(final TemplateScreen screen, int elementWidth, int elementHeight, int offsetX, int offsetY, VariableStorage variableStorage) {
        Vector2i pos = this.getPivot().apply(elementWidth, elementHeight, this.getWidth(), this.getHeight());
        pos.add(offsetX + this.getPosition().x(), offsetY + this.getPosition().y());
        TextBox textBox = new TextBox(screen.getPanel()){

            public void onTextChanged() {
                if (TextBoxTemplate.this.variableId != null) {
                    if (this.getText().isBlank()) {
                        screen.getStorage().remove(TextBoxTemplate.this.variableId);
                        return;
                    }
                    screen.getStorage().store(TextBoxTemplate.this.variableId, this.getText());
                }
            }

            public void drawTextBox(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
                int borderColor = this.isFocused() ? -1 : -6250336;
                graphics.fill(x - 1, y - 1, x + w + 1, y + h + 1, borderColor);
                graphics.fill(x, y, x + w, y + h, -16777216);
            }
        };
        if (this.defaultText != null) {
            textBox.setText(VariableProcessor.process(this.defaultText, variableStorage));
        }
        if (this.numbersOnly) {
            textBox.setFilter(str -> {
                if (str == null) {
                    return false;
                }
                if (this.characterLimit != null && str.length() > this.characterLimit) {
                    return false;
                }
                return str.chars().allMatch(Character::isDigit);
            });
        } else if (this.characterLimit != null) {
            textBox.setFilter(str -> str != null && str.length() <= this.characterLimit);
        }
        if (this.characterLimit != null) {
            textBox.charLimit = this.characterLimit;
        }
        if (this.variableId != null && screen.getStorage().contains(this.variableId)) {
            textBox.setText((String)screen.getStorage().retrieve(this.variableId));
        }
        textBox.setPosAndSize(pos.x(), pos.y(), this.getWidth(), this.getHeight());
        return textBox;
    }
}

