/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.callback.type;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.gui.screens.Screen;
import net.rocketplatform.client.api.request.RocketSubscription;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.client.RocketRequests;
import net.rocketplatform.game.client.mod.ui.template.callback.CallbackHolder;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.layout.LayoutTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.jetbrains.annotations.Nullable;

public class SubscribeCallback
extends ElementCallback {
    private static final Map<String, RocketSubscription<?>> SUBSCRIPTIONS = Map.of("player_modpack_server_created", RocketRequests.PLAYER_MODPACK_SERVER_CREATED);
    private String subscription;
    private Map<String, Object> variables;
    @SerializedName(value="loading_screen")
    private LayoutTemplate loadingScreen;
    @SerializedName(value="unsubscribe_on_response")
    private boolean unsubscribeOnResponse;
    @SerializedName(value="store_variables")
    private Map<String, String> storeVariables;
    @SerializedName(value="on_complete")
    private ElementCallback onComplete;

    public SubscribeCallback(String action) {
        super(action);
    }

    @Override
    public void onPress(TemplateScreen screen, @Nullable CallbackHolder holder, VariableStorage variableStorage) {
        Screen currentScreen;
        RocketSubscription<?> subscription = SUBSCRIPTIONS.get(this.subscription);
        if (subscription == null) {
            return;
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.variables != null) {
            for (Map.Entry<String, Object> entry : this.variables.entrySet()) {
                if (entry.getValue().toString().startsWith("$")) {
                    variables.put(entry.getKey(), variableStorage.retrieve(entry.getValue().toString().substring(1)));
                    continue;
                }
                variables.put(entry.getKey(), entry.getValue());
            }
        }
        Screen screen2 = currentScreen = this.loadingScreen == null ? null : screen.getMinecraft().screen;
        if (this.loadingScreen != null) {
            Screen loadingScreen = this.loadingScreen.createScreen(variableStorage);
            screen.getMinecraft().setScreen(loadingScreen);
        }
        ((CompletableFuture)RocketClientMod.getInstance().getClientHandler().thenApply(client -> client.executeSubscription(subscription, variables))).whenComplete((response, e) -> response.subscribe(resp -> {
            if (currentScreen != null) {
                RenderSystem.recordRenderCall(() -> screen.getMinecraft().setScreen(currentScreen));
            }
            if (e != null) {
                this.onError(holder, (Throwable)e);
                return;
            }
            if (this.unsubscribeOnResponse) {
                response.unsubscribe();
            }
            if (this.onComplete != null) {
                RenderSystem.recordRenderCall(() -> CallbackHolder.runCallbacks(screen, holder, this.onComplete, variableStorage));
            }
        }));
    }
}

