/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.network;

import alexthw.not_enough_glyphs.common.spellbinder.SpellBinder;
import alexthw.not_enough_glyphs.init.NotEnoughGlyphs;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class OpenSpellBinderPacket
extends AbstractPacket {
    InteractionHand hand;
    public static final CustomPacketPayload.Type<OpenSpellBinderPacket> TYPE = new CustomPacketPayload.Type(NotEnoughGlyphs.prefix("open_binder"));
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenSpellBinderPacket> CODEC = StreamCodec.ofMember(OpenSpellBinderPacket::encode, OpenSpellBinderPacket::new);

    public OpenSpellBinderPacket(InteractionHand hand) {
        this.hand = hand;
    }

    public void encode(RegistryFriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeBoolean(this.hand == InteractionHand.MAIN_HAND);
    }

    public OpenSpellBinderPacket(RegistryFriendlyByteBuf friendlyByteBuf) {
        this(friendlyByteBuf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
    }

    public void onServerReceived(MinecraftServer minecraft, ServerPlayer player) {
        if (player == null || this.hand == null) {
            return;
        }
        ItemStack bag = player.getItemInHand(this.hand);
        Item item = bag.getItem();
        if (item instanceof SpellBinder) {
            SpellBinder bagItem = (SpellBinder)item;
            bagItem.openContainer(player, bag);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends OpenSpellBinderPacket> type() {
        return TYPE;
    }
}

