/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common.glyphs.effects;

import alexthw.not_enough_glyphs.common.glyphs.CompatRL;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectMomentum
extends AbstractEffect {
    public static final EffectMomentum INSTANCE = new EffectMomentum();

    public EffectMomentum() {
        super(CompatRL.neg("momentum"), "Momentum");
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Entity target = rayTraceResult.getEntity();
        if (target.isPassenger()) {
            target = target.getRootVehicle();
        }
        Vec3 currentMovement = target.getDeltaMovement();
        double horizontalMagnitude = Math.sqrt(currentMovement.x * currentMovement.x + currentMovement.z * currentMovement.z);
        double normalizedX = horizontalMagnitude == 0.0 ? 0.0 : currentMovement.x / horizontalMagnitude;
        double normalizedZ = horizontalMagnitude == 0.0 ? 0.0 : currentMovement.z / horizontalMagnitude;
        double horizontalBoost = 1.5 + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier();
        double gravity = target.getGravity();
        double verticalAmp = 1.0 + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier();
        double verticalBoost = target instanceof Projectile || target.isNoGravity() ? 0.0 : ((double)Math.round(currentMovement.y * 100.0) / 100.0 >= -gravity ? gravity + 0.5 * verticalAmp : -0.5 * verticalAmp);
        Vec3 momentum = new Vec3(normalizedX * horizontalBoost, verticalBoost, normalizedZ * horizontalBoost);
        target.setDeltaMovement(currentMovement.add(momentum));
        target.hurtMarked = true;
    }

    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addAmpConfig(builder, 1.5);
        this.PER_SPELL_LIMIT = builder.comment("The maximum number of times this glyph may appear in a single spell").defineInRange("per_spell_limit", 1, 1, 10);
    }

    protected int getDefaultManaCost() {
        return 100;
    }

    protected void addAugmentCostOverrides(Map<ResourceLocation, Integer> defaults) {
        super.addAugmentCostOverrides(defaults);
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 50);
    }

    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        super.addDefaultAugmentLimits(defaults);
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 3);
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentAmplify.INSTANCE, "Increases the speed multiplier applied to the target.");
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return Set.of(AugmentAmplify.INSTANCE);
    }

    public SpellTier defaultTier() {
        return SpellTier.THREE;
    }
}

