/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.common;

import alexthw.not_enough_glyphs.api.ContingencyEffectInstance;
import alexthw.not_enough_glyphs.init.Registry;
import com.hollingsworth.arsnouveau.common.potions.PublicEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;

public class ContingencyEffect
extends PublicEffect {
    public ContingencyEffect() {
        super(MobEffectCategory.NEUTRAL, 0);
        NeoForge.EVENT_BUS.addListener(ContingencyEffect::onHealTrigger);
        NeoForge.EVENT_BUS.addListener(ContingencyEffect::onBlinkTrigger);
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGH, ContingencyEffect::onDeathEvent);
    }

    public static void onHealTrigger(LivingHealEvent event) {
        ContingencyEffectInstance cei;
        MobEffectInstance mobEffectInstance;
        if (event.getEntity().hasEffect(Registry.CONTINGENCY) && (mobEffectInstance = event.getEntity().getEffect(Registry.CONTINGENCY)) instanceof ContingencyEffectInstance && (cei = (ContingencyEffectInstance)mobEffectInstance).getTrigger() == ContingencyEffectInstance.TRIGGER.ON_HEAL) {
            cei.triggerSpell(event.getEntity());
        }
    }

    public static void onDeathEvent(LivingDeathEvent event) {
        ContingencyEffectInstance cei;
        LivingEntity entity;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof LivingEntity && (livingEntity = (entity = livingEntity).getEffect(Registry.CONTINGENCY)) instanceof ContingencyEffectInstance && (cei = (ContingencyEffectInstance)livingEntity).getTrigger() == ContingencyEffectInstance.TRIGGER.DEATH) {
            cei.triggerSpell(entity);
        }
    }

    public static void onBlinkTrigger(EntityTeleportEvent event) {
        ContingencyEffectInstance cei;
        MobEffectInstance mobEffectInstance;
        LivingEntity entity;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof LivingEntity && (entity = (LivingEntity)entity2).hasEffect(Registry.CONTINGENCY) && (mobEffectInstance = entity.getEffect(Registry.CONTINGENCY)) instanceof ContingencyEffectInstance && (cei = (ContingencyEffectInstance)mobEffectInstance).getTrigger() == ContingencyEffectInstance.TRIGGER.BLINK) {
            cei.triggerSpell(entity);
        }
    }
}

