/*
 * Decompiled with CFR 0.152.
 */
package alexthw.not_enough_glyphs.api;

import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.IFilter;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class FilterUtil {
    public static IFilter getTargetFilter(Spell spell, IFilter defaultFilter) {
        return FilterUtil.getTargetFilter(spell.recipe(), 0, defaultFilter);
    }

    public static IFilter getTargetFilter(Iterable<AbstractSpellPart> recipe, int startIdx, IFilter defaultFilter) {
        int index = -1;
        for (AbstractSpellPart part : recipe) {
            if (startIdx > ++index) continue;
            if (part instanceof IFilter) {
                return (IFilter)part;
            }
            if (!(part instanceof AbstractEffect)) continue;
            break;
        }
        return defaultFilter;
    }

    public static boolean checkIgnoreFilters(Entity e, Set<IFilter> filters) {
        boolean flag = true;
        if (filters == null) {
            return true;
        }
        for (IFilter spellPart : filters) {
            flag &= spellPart.shouldAffect((HitResult)new EntityHitResult(e), e.level());
        }
        return !flag;
    }

    public static Set<IFilter> getFilters(Iterable<AbstractSpellPart> recipe, int startIndex) {
        HashSet<IFilter> list = new HashSet<IFilter>();
        int index = -1;
        for (AbstractSpellPart glyph : recipe) {
            if (startIndex < ++index || glyph instanceof AbstractCastMethod) continue;
            if (glyph instanceof IFilter) {
                IFilter filter = (IFilter)glyph;
                list.add(filter);
                continue;
            }
            if (!(glyph instanceof AbstractEffect)) continue;
            break;
        }
        return list;
    }

    public static Predicate<Entity> getFilterPredicate(Spell spell, Predicate<Entity> defaultFilter) {
        Set<IFilter> set = FilterUtil.getFilters(spell.recipe(), 0);
        if (set.isEmpty()) {
            return defaultFilter;
        }
        return entity -> !FilterUtil.checkIgnoreFilters(entity, set);
    }
}

