/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet;

import java.util.function.Function;
import java.util.function.Supplier;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.datagen.DataGen;
import mcjty.lib.modules.IModule;
import mcjty.lib.modules.Modules;
import mcjty.xnet.apiimpl.XNetApi;
import mcjty.xnet.modules.cables.CableModule;
import mcjty.xnet.modules.cables.blocks.ConnectorTileEntity;
import mcjty.xnet.modules.controller.ControllerModule;
import mcjty.xnet.modules.facade.FacadeModule;
import mcjty.xnet.modules.facade.client.ClientSetup;
import mcjty.xnet.modules.router.RouterModule;
import mcjty.xnet.modules.various.VariousModule;
import mcjty.xnet.modules.wireless.WirelessRouterModule;
import mcjty.xnet.setup.Config;
import mcjty.xnet.setup.ModSetup;
import mcjty.xnet.setup.Registration;
import mcjty.xnet.setup.XNetMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.IBlockCapabilityProvider;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

@Mod(value="xnet")
public class XNet {
    public static final String MODID = "xnet";
    public static final ModSetup setup = new ModSetup();
    public static XNet instance;
    private final Modules modules = new Modules();
    public static final XNetApi xNetApi;

    public XNet(ModContainer mod, IEventBus bus, Dist dist) {
        instance = this;
        this.setupModules(bus, dist);
        Config.register(mod, this.modules);
        Registration.register(bus);
        bus.addListener(setup::init);
        bus.addListener(arg_0 -> ((Modules)this.modules).init(arg_0));
        bus.addListener(this::processIMC);
        bus.addListener(this::onDataGen);
        bus.addListener(XNetMessages::registerMessages);
        bus.addListener(setup.getBlockCapabilityRegistrar(Registration.RBLOCKS));
        bus.addListener(this::onRegisterCapabilities);
        if (dist.isClient()) {
            bus.addListener(arg_0 -> ((Modules)this.modules).initClient(arg_0));
            bus.addListener(ClientSetup::registerBlockColor);
        }
    }

    public static <T extends Item> Supplier<T> tab(Supplier<T> supplier) {
        return setup.tab(supplier);
    }

    private void onDataGen(GatherDataEvent event) {
        DataGen datagen = new DataGen(MODID, event);
        this.modules.datagen(datagen, event.getLookupProvider());
        datagen.generate();
    }

    private void setupModules(IEventBus bus, Dist dist) {
        this.modules.register((IModule)new CableModule(bus, dist));
        this.modules.register((IModule)new ControllerModule(bus));
        this.modules.register((IModule)new FacadeModule());
        this.modules.register((IModule)new RouterModule(bus));
        this.modules.register((IModule)new WirelessRouterModule(bus));
        this.modules.register((IModule)new VariousModule());
    }

    private void processIMC(InterModProcessEvent event) {
        event.getIMCStream().forEach(message -> {
            if ("getXNet".equalsIgnoreCase(message.method())) {
                Supplier supplier = message.getMessageSupplier();
                ((Function)supplier.get()).apply(xNetApi);
            }
        });
    }

    private void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlock(CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY, (IBlockCapabilityProvider)new IBlockCapabilityProvider<MenuProvider, Direction>(this){

            @Nullable
            public MenuProvider getCapability(Level level, BlockPos blockPos, BlockState blockState, @Nullable BlockEntity blockEntity, Direction direction) {
                if (blockEntity instanceof ConnectorTileEntity) {
                    ConnectorTileEntity connector = (ConnectorTileEntity)blockEntity;
                    return ConnectorTileEntity.SCREEN_CAP.apply(connector);
                }
                return null;
            }
        }, new Block[]{(Block)CableModule.CONNECTOR.get(), (Block)CableModule.ADVANCED_CONNECTOR.get()});
        event.registerBlock(Capabilities.EnergyStorage.BLOCK, (IBlockCapabilityProvider)new IBlockCapabilityProvider<IEnergyStorage, Direction>(this){

            @Nullable
            public IEnergyStorage getCapability(Level level, BlockPos blockPos, BlockState blockState, @Nullable BlockEntity blockEntity, Direction direction) {
                if (blockEntity instanceof ConnectorTileEntity) {
                    ConnectorTileEntity connector = (ConnectorTileEntity)blockEntity;
                    return connector.getEnergyStorage(direction);
                }
                return null;
            }
        }, new Block[]{(Block)CableModule.CONNECTOR.get(), (Block)CableModule.ADVANCED_CONNECTOR.get()});
    }

    static {
        xNetApi = new XNetApi();
    }
}

