/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import cpw.mods.inventorysorter.Config;
import cpw.mods.inventorysorter.InventorySorterCommand;
import cpw.mods.inventorysorter.KeyHandler;
import cpw.mods.inventorysorter.Network;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="inventorysorter")
public class InventorySorter {
    public static InventorySorter INSTANCE;
    static final Logger LOGGER;
    ResourceLocation lastContainerType;
    boolean debugLog;
    private final Set<String> slotblacklist = new HashSet<String>();
    private final Set<String> containerblacklist = new HashSet<String>();
    private boolean dodgeMouseTweaks;
    private static final DeferredRegister<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENT_TYPES;
    private static final DeferredHolder<ArgumentTypeInfo<?, ?>, SingletonArgumentInfo<InventorySorterCommand.ContainerResourceLocationArgument>> CONTAINER_CLASS;

    public InventorySorter(IEventBus modBus, ModContainer me) {
        INSTANCE = this;
        IEventBus bus = modBus;
        bus.addListener(this::handleimc);
        bus.addListener(this::onConfigLoad);
        Config.register(me);
        COMMAND_ARGUMENT_TYPES.register(bus);
        NeoForge.EVENT_BUS.addListener(this::onCommandRegister);
        KeyHandler.registerKeyHandlers(bus);
        Network.registerPayloadHandlers(bus);
    }

    private void handleimc(InterModProcessEvent evt) {
        Stream imc = InterModComms.getMessages((String)"inventorysorter");
        imc.forEach(this::handleimcmessage);
    }

    private void handleimcmessage(InterModComms.IMCMessage msg) {
        ResourceLocation slotContainerTarget;
        String slotBlacklistTarget;
        if ("slotblacklist".equals(msg.method()) && this.slotblacklist.add(slotBlacklistTarget = (String)msg.messageSupplier().get())) {
            this.debugLog("SlotBlacklist added {}", () -> new String[]{slotBlacklistTarget});
        }
        if ("containerblacklist".equals(msg.method()) && this.containerblacklist.add((slotContainerTarget = (ResourceLocation)msg.messageSupplier().get()).toString())) {
            this.debugLog("ContainerBlacklist added {}", () -> new String[]{slotContainerTarget.toString()});
        }
    }

    private void updateConfig() {
        Config.ServerConfig.CONFIG.containerBlacklist.set(new ArrayList<String>(this.containerblacklist));
        Config.ServerConfig.CONFIG.slotBlacklist.set(new ArrayList<String>(this.slotblacklist));
        Config.ServerConfig.SPEC.save();
    }

    private void onCommandRegister(RegisterCommandsEvent evt) {
        InventorySorterCommand.register((CommandDispatcher<CommandSourceStack>)evt.getDispatcher());
    }

    boolean isSlotBlacklisted(Slot slot) {
        return this.slotblacklist.contains(slot.getClass().getName()) || ((List)Config.ServerConfig.CONFIG.slotBlacklist.get()).contains(slot.getClass().getName());
    }

    boolean isContainerBlacklisted(ResourceLocation container) {
        return this.containerblacklist.contains(container.toString()) || ((List)Config.ServerConfig.CONFIG.containerBlacklist.get()).contains(container.toString());
    }

    void onConfigLoad(ModConfigEvent configEvent) {
        if (configEvent instanceof ModConfigEvent.Unloading) {
            return;
        }
        switch (configEvent.getConfig().getType()) {
            case SERVER: {
                this.slotblacklist.addAll((Collection)Config.ServerConfig.CONFIG.slotBlacklist.get());
                this.containerblacklist.addAll((Collection)Config.ServerConfig.CONFIG.containerBlacklist.get());
                break;
            }
            case CLIENT: {
                if (!((Boolean)Config.ClientConfig.CONFIG.dodgeMousetweaks.get()).booleanValue() || !ModList.get().isLoaded("mousetweaks")) break;
                this.dodgeMouseTweaks = true;
            }
        }
    }

    final void debugLog(String message, Supplier<String[]> args) {
        if (this.debugLog) {
            LOGGER.error(message, (Object[])args.get());
        }
    }

    private static Component greenText(String string) {
        MutableComponent tcs = Component.translatable((String)string);
        tcs.getStyle().withColor(ChatFormatting.GREEN);
        return tcs;
    }

    static int blackListAdd(CommandContext<CommandSourceStack> context) {
        ResourceLocation containerType = (ResourceLocation)context.getArgument("container", ResourceLocation.class);
        if (BuiltInRegistries.MENU.containsKey(containerType)) {
            InventorySorter.INSTANCE.containerblacklist.add(containerType.toString());
            INSTANCE.updateConfig();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"inventorysorter.commands.inventorysorter.bladd.message", (Object[])new Object[]{containerType.toString()}), true);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"inventorysorter.commands.inventorysorter.badtype", (Object[])new Object[]{containerType}), true);
        return 0;
    }

    static int blackListRemove(CommandContext<CommandSourceStack> context) {
        ResourceLocation containerType = (ResourceLocation)context.getArgument("container", ResourceLocation.class);
        if (BuiltInRegistries.MENU.containsKey(containerType) && InventorySorter.INSTANCE.containerblacklist.remove(containerType.toString())) {
            INSTANCE.updateConfig();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"inventorysorter.commands.inventorysorter.blremove.message", (Object[])new Object[]{containerType.toString()}), true);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"inventorysorter.commands.inventorysorter.badtype", (Object[])new Object[]{containerType.toString()}), true);
        return 0;
    }

    static int showLast(CommandContext<CommandSourceStack> context) {
        if (InventorySorter.INSTANCE.lastContainerType != null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"inventorysorter.commands.inventorysorter.showlast.message", (Object[])new Object[]{InventorySorter.INSTANCE.lastContainerType.toString()}), true);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"inventorysorter.commands.inventorysorter.showlast.nosort"), true);
        }
        return 0;
    }

    static int showBlacklist(CommandContext<CommandSourceStack> context) {
        if (InventorySorter.INSTANCE.containerblacklist.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"inventorysorter.commands.inventorysorter.showblacklist.empty"), true);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"inventorysorter.commands.inventorysorter.showblacklist.message", (Object[])new Object[]{InventorySorter.listBlacklist().map(ResourceLocation::toString).collect(Collectors.joining(", "))}), true);
        }
        return 0;
    }

    static Stream<ResourceLocation> listContainers() {
        return BuiltInRegistries.MENU.entrySet().stream().map(e -> ((ResourceKey)e.getKey()).location());
    }

    static Stream<ResourceLocation> listBlacklist() {
        return InventorySorter.INSTANCE.containerblacklist.stream().map(ResourceLocation::parse);
    }

    boolean dontDodgeMouseTweaks() {
        return !this.dodgeMouseTweaks;
    }

    static {
        LOGGER = LogManager.getLogger();
        COMMAND_ARGUMENT_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.COMMAND_ARGUMENT_TYPE, (String)"inventorysorter");
        CONTAINER_CLASS = COMMAND_ARGUMENT_TYPES.register("container_reslocation", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(InventorySorterCommand.ContainerResourceLocationArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.contextFree(InventorySorterCommand.ContainerResourceLocationArgument::new)));
    }
}

