/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.net;

import de.maxhenkel.camera.ImageTools;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.corelib.net.Message;
import de.maxhenkel.camera.net.MessageImage;
import de.maxhenkel.camera.net.MessageImageUnavailable;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessageRequestImage
implements Message<MessageRequestImage> {
    public static final CustomPacketPayload.Type<MessageRequestImage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"camera", (String)"request_image"));
    private UUID imgUUID;

    public MessageRequestImage() {
    }

    public MessageRequestImage(UUID imgUUID) {
        this.imgUUID = imgUUID;
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public void executeServerSide(IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)player;
        try {
            byte[] data = ImageTools.toBytes(Main.PACKET_MANAGER.getExistingImage(sender, this.imgUUID));
            context.reply((CustomPacketPayload)new MessageImage(this.imgUUID, data));
        }
        catch (IOException e) {
            e.printStackTrace();
            context.reply((CustomPacketPayload)new MessageImageUnavailable(this.imgUUID));
        }
    }

    @Override
    public MessageRequestImage fromBytes(RegistryFriendlyByteBuf buf) {
        this.imgUUID = buf.readUUID();
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeUUID(this.imgUUID);
    }

    @Override
    public CustomPacketPayload.Type<MessageRequestImage> type() {
        return TYPE;
    }
}

