/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.inventory;

import de.maxhenkel.camera.ImageData;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.items.AlbumItem;
import de.maxhenkel.camera.items.ImageItem;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemContainerContents;

public class AlbumInventory
implements Container {
    public static final int SIZE = 54;
    private NonNullList<ItemStack> items;
    private ItemStack album;

    public AlbumInventory(HolderLookup.Provider provider, ItemStack album) {
        assert (!album.isEmpty());
        this.album = album;
        this.items = NonNullList.withSize((int)54, (Object)ItemStack.EMPTY);
        AlbumInventory.convert(provider, album);
        ItemContainerContents contents = (ItemContainerContents)album.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        contents.copyInto(this.items);
    }

    public int getContainerSize() {
        return 54;
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack removeItem(int index, int count) {
        ItemStack itemstack = ContainerHelper.removeItem(this.items, (int)index, (int)count);
        this.setChanged();
        return itemstack;
    }

    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.items, (int)index);
    }

    public void setItem(int index, ItemStack stack) {
        this.items.set(index, (Object)stack);
        this.setChanged();
    }

    public int getMaxStackSize() {
        return 64;
    }

    public void setChanged() {
        this.album.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.items));
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return !(stack.getItem() instanceof ImageItem);
    }

    public void clearContent() {
        this.items.clear();
        this.setChanged();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public boolean stillValid(Player player) {
        for (InteractionHand hand : InteractionHand.values()) {
            if (!player.getItemInHand(hand).equals(this.album)) continue;
            return true;
        }
        return false;
    }

    public static void convert(HolderLookup.Provider provider, ItemStack album) {
        if (!(album.getItem() instanceof AlbumItem)) {
            return;
        }
        CustomData customData = (CustomData)album.get(DataComponents.CUSTOM_DATA);
        if (customData == null) {
            return;
        }
        CompoundTag itemTag = customData.copyTag();
        if (!itemTag.contains("Images", 10)) {
            return;
        }
        CompoundTag images = itemTag.getCompound("Images");
        itemTag.remove("Images");
        if (itemTag.isEmpty()) {
            album.remove(DataComponents.CUSTOM_DATA);
        } else {
            album.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)itemTag));
        }
        NonNullList items = NonNullList.withSize((int)54, (Object)ItemStack.EMPTY);
        ListTag itemsTag = images.getList("Items", 10);
        for (int i = 0; i < itemsTag.size(); ++i) {
            CompoundTag compoundtag = itemsTag.getCompound(i);
            int j = compoundtag.getByte("Slot") & 0xFF;
            if (j > items.size()) continue;
            ItemStack itemStack = ItemStack.parse((HolderLookup.Provider)provider, (Tag)compoundtag).orElse(ItemStack.EMPTY);
            CompoundTag tag = compoundtag.getCompound("tag");
            ImageData imageData = ImageData.fromImageTag(tag.getCompound("image"));
            if (imageData == null) {
                items.set(j, (Object)itemStack);
                continue;
            }
            itemStack.set(Main.IMAGE_DATA_COMPONENT, (Object)imageData);
            items.set(j, (Object)itemStack);
        }
        album.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)items));
    }
}

