/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.items.CameraItem;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="camera")
public class ServerEvents {
    @SubscribeEvent
    public static void onTick(PlayerTickEvent.Pre event) {
        if (event.getEntity().getMainHandItem().getItem().equals(Main.CAMERA.get()) || event.getEntity().getOffhandItem().getItem().equals(Main.CAMERA.get())) {
            return;
        }
        ServerEvents.disableCamera(event.getEntity().getInventory().getSelected());
        for (ItemStack stack : event.getEntity().getInventory().items) {
            ServerEvents.disableCamera(stack);
        }
        for (ItemStack stack : event.getEntity().getInventory().offhand) {
            ServerEvents.disableCamera(stack);
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack item = player.getItemInHand(hand);
            if (!item.getItem().equals(Main.CAMERA.get()) || !((CameraItem)((Object)Main.CAMERA.get())).isActive(item)) continue;
            event.setUseBlock(TriState.FALSE);
            event.setCanceled(true);
            break;
        }
    }

    @SubscribeEvent
    public static void onHit(LivingIncomingDamageEvent event) {
        Entity source = event.getSource().getDirectEntity();
        if (!(source instanceof Player)) {
            return;
        }
        Player player = (Player)source;
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = player.getItemInHand(hand);
            if (!stack.getItem().equals(Main.CAMERA.get()) || !((CameraItem)((Object)Main.CAMERA.get())).isActive(stack)) continue;
            event.setCanceled(true);
            break;
        }
    }

    @SubscribeEvent
    public static void onItemToss(ItemTossEvent event) {
        ServerEvents.disableCamera(event.getEntity().getItem());
    }

    private static void disableCamera(ItemStack stack) {
        if (stack.getItem().equals(Main.CAMERA.get())) {
            ((CameraItem)((Object)Main.CAMERA.get())).setActive(stack, false);
        }
    }
}

