/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.items;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.CompositeStreamCodec;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.TextAlign;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsbuilder.modules.mover.MoverConfiguration;
import mcjty.rftoolsbuilder.modules.mover.blocks.MoverControllerTileEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public record VehicleControlScreenModule(GlobalPos pos, String line, String mover, String vehicle, String button, int color, int buttonColor, String monitor, TextAlign align) implements IScreenModule<VehicleControlScreenModule, EmptyData>
{
    public static final VehicleControlScreenModule DEFAULT = new VehicleControlScreenModule(GlobalPos.of((ResourceKey)Level.OVERWORLD, (BlockPos)BlockPosTools.INVALID), "", "", "", "", 0xFFFFFF, 0xFFFFFF, "", TextAlign.ALIGN_LEFT);
    public static final Codec<VehicleControlScreenModule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GlobalPos.CODEC.fieldOf("pos").forGetter(module -> module.pos), (App)Codec.STRING.fieldOf("line").forGetter(module -> module.line), (App)Codec.STRING.fieldOf("mover").forGetter(module -> module.mover), (App)Codec.STRING.fieldOf("vehicle").forGetter(module -> module.vehicle), (App)Codec.STRING.fieldOf("button").forGetter(module -> module.button), (App)Codec.INT.fieldOf("color").forGetter(module -> module.color), (App)Codec.INT.fieldOf("buttonColor").forGetter(module -> module.buttonColor), (App)Codec.STRING.optionalFieldOf("monitor", (Object)"").forGetter(module -> module.monitor), (App)TextAlign.CODEC.fieldOf("align").forGetter(module -> module.align)).apply((Applicative)instance, VehicleControlScreenModule::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, VehicleControlScreenModule> STREAM_CODEC = CompositeStreamCodec.composite((StreamCodec)GlobalPos.STREAM_CODEC, module -> module.pos, (StreamCodec)ByteBufCodecs.STRING_UTF8, module -> module.line, (StreamCodec)ByteBufCodecs.STRING_UTF8, module -> module.mover, (StreamCodec)ByteBufCodecs.STRING_UTF8, module -> module.vehicle, (StreamCodec)ByteBufCodecs.STRING_UTF8, module -> module.button, (StreamCodec)ByteBufCodecs.INT, module -> module.color, (StreamCodec)ByteBufCodecs.INT, module -> module.buttonColor, (StreamCodec)ByteBufCodecs.STRING_UTF8, module -> module.monitor, (StreamCodec)TextAlign.STREAM_CODEC, module -> module.align, VehicleControlScreenModule::new);

    public GlobalPos getPos() {
        return this.pos;
    }

    public String getLine() {
        return this.line;
    }

    public String getMover() {
        return this.mover;
    }

    public String getVehicle() {
        return this.vehicle;
    }

    public String getButton() {
        return this.button;
    }

    public int getColor() {
        return this.color;
    }

    public int getButtonColor() {
        return this.buttonColor;
    }

    public String getMonitor() {
        return this.monitor;
    }

    public TextAlign getAlign() {
        return this.align;
    }

    public VehicleControlScreenModule withLine(String line) {
        return new VehicleControlScreenModule(this.pos, line, this.mover, this.vehicle, this.button, this.color, this.buttonColor, this.monitor, this.align);
    }

    public VehicleControlScreenModule withMover(String mover) {
        return new VehicleControlScreenModule(this.pos, this.line, mover, this.vehicle, this.button, this.color, this.buttonColor, this.monitor, this.align);
    }

    public VehicleControlScreenModule withVehicle(String vehicle) {
        return new VehicleControlScreenModule(this.pos, this.line, this.mover, vehicle, this.button, this.color, this.buttonColor, this.monitor, this.align);
    }

    public VehicleControlScreenModule withButton(String button) {
        return new VehicleControlScreenModule(this.pos, this.line, this.mover, this.vehicle, button, this.color, this.buttonColor, this.monitor, this.align);
    }

    public VehicleControlScreenModule withColor(int color) {
        return new VehicleControlScreenModule(this.pos, this.line, this.mover, this.vehicle, this.button, color, this.buttonColor, this.monitor, this.align);
    }

    public VehicleControlScreenModule withButtonColor(int buttonColor) {
        return new VehicleControlScreenModule(this.pos, this.line, this.mover, this.vehicle, this.button, this.color, buttonColor, this.monitor, this.align);
    }

    public VehicleControlScreenModule withMonitor(String monitor) {
        return new VehicleControlScreenModule(this.pos, this.line, this.mover, this.vehicle, this.button, this.color, this.buttonColor, monitor, this.align);
    }

    public VehicleControlScreenModule withAlign(TextAlign align) {
        return new VehicleControlScreenModule(this.pos, this.line, this.mover, this.vehicle, this.button, this.color, this.buttonColor, this.monitor, align);
    }

    public VehicleControlScreenModule withPos(GlobalPos pos) {
        return new VehicleControlScreenModule(pos, this.line, this.mover, this.vehicle, this.button, this.color, this.buttonColor, this.monitor, this.align);
    }

    public VehicleControlScreenModule withPos(ResourceKey<Level> dim, BlockPos coordinate) {
        return new VehicleControlScreenModule(GlobalPos.of(dim, (BlockPos)coordinate), this.line, this.mover, this.vehicle, this.button, this.color, this.buttonColor, this.monitor, this.align);
    }

    public EmptyData getData(IScreenDataHelper helper, Level worldObj, long millis) {
        return null;
    }

    public VehicleControlScreenModule validate(Level world, BlockPos pos, boolean isPlus) {
        return this;
    }

    public int getRfPerTick() {
        return (Integer)MoverConfiguration.VEHICLE_CONTROL_RFPERTICK.get();
    }

    public void mouseClick(Level world, int x, int y, boolean clicked, Player player) {
        int xoffset = !this.line.isEmpty() ? 40 : 5;
        if (x >= xoffset) {
            if (!this.mover.isEmpty()) {
                VehicleControlScreenModule.getMoverController(world, (ResourceKey<Level>)this.pos.dimension(), this.pos.pos()).ifPresent(controller -> controller.setupMovement(this.mover, this.vehicle));
            } else if (player != null) {
                player.displayClientMessage((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.RED) + "Module is not linked to mover controller!")), false);
            }
        }
    }

    public static Optional<MoverControllerTileEntity> getMoverController(Level worldObj, ResourceKey<Level> dim, BlockPos coordinate) {
        ServerLevel world = LevelTools.getLevel((Level)worldObj, dim);
        if (world == null) {
            return Optional.empty();
        }
        if (!LevelTools.isLoaded((Level)world, (BlockPos)coordinate)) {
            return Optional.empty();
        }
        BlockEntity te = world.getBlockEntity(coordinate);
        if (te == null) {
            return Optional.empty();
        }
        if (!(te instanceof MoverControllerTileEntity)) {
            return Optional.empty();
        }
        return Optional.of((MoverControllerTileEntity)te);
    }

    public static class EmptyData
    implements IModuleData {
        public static final String ID = "rftoolsbuilder:vehicle_control";

        public EmptyData(FriendlyByteBuf buf) {
        }

        public String getId() {
            return ID;
        }

        public void writeToBuf(RegistryFriendlyByteBuf buf) {
        }
    }
}

