/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover;

import mcjty.lib.datagen.BaseBlockStateProvider;
import mcjty.rftoolsbuilder.modules.mover.blocks.MoverControlBlock;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public class DataGenHelper {
    public static void create24Model(BaseBlockStateProvider provider, Block block, String modelPrefix, String txt) {
        ModelFile model0 = DataGenHelper.controlModuleBlock(provider, modelPrefix + "0", provider.modLoc(txt), 0, ModelBuilder.FaceRotation.ZERO);
        ModelFile model90 = DataGenHelper.controlModuleBlock(provider, modelPrefix + "90", provider.modLoc(txt), 0, ModelBuilder.FaceRotation.CLOCKWISE_90);
        ModelFile model180 = DataGenHelper.controlModuleBlock(provider, modelPrefix + "180", provider.modLoc(txt), 0, ModelBuilder.FaceRotation.UPSIDE_DOWN);
        ModelFile model270 = DataGenHelper.controlModuleBlock(provider, modelPrefix + "270", provider.modLoc(txt), 0, ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90);
        provider.orientedBlock(block, (blockState, bld) -> {
            ModelFile model = DataGenHelper.getModelOriented24(model0, model90, model180, model270, blockState);
            bld.modelFile(model);
        });
    }

    private static ModelFile getModelOriented24(ModelFile model0, ModelFile model90, ModelFile model180, ModelFile model270, BlockState blockState) {
        return switch ((Direction)blockState.getValue((Property)BlockStateProperties.FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> {
                switch ((Direction)blockState.getValue((Property)MoverControlBlock.HORIZ_FACING)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case DOWN: {
                        yield model0;
                    }
                    case UP: {
                        yield model0;
                    }
                    case NORTH: {
                        yield model0;
                    }
                    case SOUTH: {
                        yield model180;
                    }
                    case WEST: {
                        yield model270;
                    }
                    case EAST: 
                }
                yield model90;
            }
            case Direction.DOWN -> {
                switch ((Direction)blockState.getValue((Property)MoverControlBlock.HORIZ_FACING)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case DOWN: {
                        yield model0;
                    }
                    case UP: {
                        yield model0;
                    }
                    case NORTH: {
                        yield model180;
                    }
                    case SOUTH: {
                        yield model0;
                    }
                    case WEST: {
                        yield model90;
                    }
                    case EAST: 
                }
                yield model270;
            }
            case Direction.NORTH -> model0;
            case Direction.SOUTH -> model0;
            case Direction.WEST -> model0;
            case Direction.EAST -> model0;
        };
    }

    public static ModelFile controlModuleBlock(BaseBlockStateProvider provider, String modelName, ResourceLocation texture, int offset, ModelBuilder.FaceRotation faceRotation) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder("block/" + modelName)).parent((ModelFile)provider.models().getExistingFile(provider.mcLoc("block")));
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)model.element().from(0.0f, 0.0f, (float)offset).to(16.0f, 16.0f, 16.0f).face(Direction.DOWN).cullface(Direction.DOWN).texture("#side").end().face(Direction.UP).cullface(Direction.UP).texture("#top").end().face(Direction.EAST).cullface(Direction.EAST).texture("#side").end().face(Direction.WEST).cullface(Direction.WEST).texture("#side").end().face(Direction.NORTH).texture("#front").rotation(faceRotation).end().face(Direction.SOUTH).cullface(Direction.SOUTH).texture("#side").end().end()).texture("side", BaseBlockStateProvider.RFTOOLSBASE_SIDE)).texture("top", BaseBlockStateProvider.RFTOOLSBASE_TOP)).texture("particle", BaseBlockStateProvider.RFTOOLSBASE_SIDE)).texture("front", texture);
        return model;
    }
}

