/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import mcjty.lib.varia.CompositeStreamCodec;
import mcjty.rftoolsbuilder.modules.builder.blocks.AnchorMode;
import mcjty.rftoolsbuilder.modules.builder.blocks.BuilderMode;
import mcjty.rftoolsbuilder.modules.builder.blocks.RotateMode;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record BuilderData(String lastError, BuilderMode mode, AnchorMode anchor, RotateMode rotate, Flags flags, BlockPos scan, BlockPos minBox, BlockPos maxBox) {
    public static final Flags DEFAULT_FLAGS = new Flags(false, false, false, false, true, false);
    public static final Codec<Flags> FLAGS_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("silent").forGetter(Flags::silent), (App)Codec.BOOL.fieldOf("supportMode").forGetter(Flags::supportMode), (App)Codec.BOOL.fieldOf("entityMode").forGetter(Flags::entityMode), (App)Codec.BOOL.fieldOf("loopMode").forGetter(Flags::loopMode), (App)Codec.BOOL.fieldOf("waitMode").forGetter(Flags::waitMode), (App)Codec.BOOL.fieldOf("hilightMode").forGetter(Flags::hilightMode)).apply((Applicative)instance, Flags::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Flags> FLAGS_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, Flags::silent, (StreamCodec)ByteBufCodecs.BOOL, Flags::supportMode, (StreamCodec)ByteBufCodecs.BOOL, Flags::entityMode, (StreamCodec)ByteBufCodecs.BOOL, Flags::loopMode, (StreamCodec)ByteBufCodecs.BOOL, Flags::waitMode, (StreamCodec)ByteBufCodecs.BOOL, Flags::hilightMode, Flags::new);
    public static final BuilderData DEFAULT = new BuilderData(null, BuilderMode.MODE_COPY, AnchorMode.ANCHOR_SW, RotateMode.ROTATE_0, DEFAULT_FLAGS, null, null, null);
    public static final Codec<BuilderData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("lasterror").forGetter(data -> Optional.ofNullable(data.lastError())), (App)BuilderMode.CODEC.fieldOf("mode").forGetter(BuilderData::mode), (App)AnchorMode.CODEC.fieldOf("anchor").forGetter(BuilderData::anchor), (App)RotateMode.CODEC.fieldOf("rotate").forGetter(BuilderData::rotate), (App)FLAGS_CODEC.fieldOf("flags").forGetter(BuilderData::flags), (App)BlockPos.CODEC.optionalFieldOf("scan").forGetter(data -> Optional.ofNullable(data.scan())), (App)BlockPos.CODEC.optionalFieldOf("minBox").forGetter(data -> Optional.ofNullable(data.minBox())), (App)BlockPos.CODEC.optionalFieldOf("maxBox").forGetter(data -> Optional.ofNullable(data.maxBox()))).apply((Applicative)instance, (lasterror, mode, anchor, rotate, flags, scan, minBox, maxBox) -> new BuilderData(lasterror.orElse(null), (BuilderMode)((Object)((Object)mode)), (AnchorMode)((Object)((Object)anchor)), (RotateMode)((Object)((Object)rotate)), (Flags)flags, scan.orElse(null), minBox.orElse(null), maxBox.orElse(null))));
    public static final StreamCodec<RegistryFriendlyByteBuf, BuilderData> STREAM_CODEC = CompositeStreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), data -> Optional.ofNullable(data.lastError()), BuilderMode.STREAM_CODEC, BuilderData::mode, AnchorMode.STREAM_CODEC, BuilderData::anchor, RotateMode.STREAM_CODEC, BuilderData::rotate, FLAGS_STREAM_CODEC, BuilderData::flags, (StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC), data -> Optional.ofNullable(data.scan()), (StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC), data -> Optional.ofNullable(data.minBox()), (StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC), data -> Optional.ofNullable(data.maxBox()), (lastError, mode, anchor, rotate, flags, scan, minBox, maxBox) -> new BuilderData(lastError.orElse(null), (BuilderMode)((Object)mode), (AnchorMode)((Object)anchor), (RotateMode)((Object)rotate), (Flags)flags, scan.orElse(null), minBox.orElse(null), maxBox.orElse(null)));

    public BuilderData withLastError(String lastError) {
        return new BuilderData(lastError, this.mode, this.anchor, this.rotate, this.flags, this.scan, this.minBox, this.maxBox);
    }

    public BuilderData withMode(BuilderMode mode) {
        return new BuilderData(this.lastError, mode, this.anchor, this.rotate, this.flags, this.scan, this.minBox, this.maxBox);
    }

    public BuilderData withAnchor(AnchorMode anchor) {
        return new BuilderData(this.lastError, this.mode, anchor, this.rotate, this.flags, this.scan, this.minBox, this.maxBox);
    }

    public BuilderData withRotate(RotateMode rotate) {
        return new BuilderData(this.lastError, this.mode, this.anchor, rotate, this.flags, this.scan, this.minBox, this.maxBox);
    }

    public BuilderData withSilent(boolean silent) {
        return new BuilderData(this.lastError, this.mode, this.anchor, this.rotate, new Flags(silent, this.flags.supportMode, this.flags.entityMode, this.flags.loopMode, this.flags.waitMode, this.flags.hilightMode), this.scan, this.minBox, this.maxBox);
    }

    public BuilderData withSupportMode(boolean supportMode) {
        return new BuilderData(this.lastError, this.mode, this.anchor, this.rotate, new Flags(this.flags.silent, supportMode, this.flags.entityMode, this.flags.loopMode, this.flags.waitMode, this.flags.hilightMode), this.scan, this.minBox, this.maxBox);
    }

    public BuilderData withEntityMode(boolean entityMode) {
        return new BuilderData(this.lastError, this.mode, this.anchor, this.rotate, new Flags(this.flags.silent, this.flags.supportMode, entityMode, this.flags.loopMode, this.flags.waitMode, this.flags.hilightMode), this.scan, this.minBox, this.maxBox);
    }

    public BuilderData withLoopMode(boolean loopMode) {
        return new BuilderData(this.lastError, this.mode, this.anchor, this.rotate, new Flags(this.flags.silent, this.flags.supportMode, this.flags.entityMode, loopMode, this.flags.waitMode, this.flags.hilightMode), this.scan, this.minBox, this.maxBox);
    }

    public BuilderData withWaitMode(boolean waitMode) {
        return new BuilderData(this.lastError, this.mode, this.anchor, this.rotate, new Flags(this.flags.silent, this.flags.supportMode, this.flags.entityMode, this.flags.loopMode, waitMode, this.flags.hilightMode), this.scan, this.minBox, this.maxBox);
    }

    public BuilderData withHilightMode(boolean hilightMode) {
        return new BuilderData(this.lastError, this.mode, this.anchor, this.rotate, new Flags(this.flags.silent, this.flags.supportMode, this.flags.entityMode, this.flags.loopMode, this.flags.waitMode, hilightMode), this.scan, this.minBox, this.maxBox);
    }

    public BuilderData withScan(BlockPos scan) {
        return new BuilderData(this.lastError, this.mode, this.anchor, this.rotate, this.flags, scan, this.minBox, this.maxBox);
    }

    public BuilderData withMinBox(BlockPos minBox) {
        return new BuilderData(this.lastError, this.mode, this.anchor, this.rotate, this.flags, this.scan, minBox, this.maxBox);
    }

    public BuilderData withMaxBox(BlockPos maxBox) {
        return new BuilderData(this.lastError, this.mode, this.anchor, this.rotate, this.flags, this.scan, this.minBox, maxBox);
    }

    public record Flags(boolean silent, boolean supportMode, boolean entityMode, boolean loopMode, boolean waitMode, boolean hilightMode) {
    }
}

