/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.client;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.blay09.mods.inventoryessentials.InventoryEssentialsConfig;
import net.blay09.mods.inventoryessentials.client.InventoryEssentialsClient;
import net.blay09.mods.inventoryessentials.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.kuma.api.InputBinding;
import net.blay09.mods.kuma.api.KeyConflictContext;
import net.blay09.mods.kuma.api.KeyModifier;
import net.blay09.mods.kuma.api.KeyModifiers;
import net.blay09.mods.kuma.api.Kuma;
import net.blay09.mods.kuma.api.ManagedKeyMapping;
import net.blay09.mods.kuma.api.ScreenInputEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;

public class ModKeyMappings {
    public static ManagedKeyMapping keySingleTransfer;
    public static ManagedKeyMapping keyBulkTransfer;
    public static ManagedKeyMapping keyBulkTransferSingle;
    public static ManagedKeyMapping keyBulkTransferAll;
    public static ManagedKeyMapping keyBulkDrop;
    public static ManagedKeyMapping keyScreenBulkDrop;
    public static ManagedKeyMapping keyDragTransfer;

    public static void initialize() {
        keySingleTransfer = Kuma.createKeyMapping((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"inventoryessentials", (String)"single_transfer")).withDefault(InputBinding.mouse((int)0, (KeyModifiers)KeyModifiers.of((KeyModifier[])new KeyModifier[]{KeyModifier.CONTROL}))).handleScreenInput(event -> ModKeyMappings.handleSlotInput(event, () -> InventoryEssentialsConfig.getActive().enableSingleTransfer, (screen, slot) -> InventoryEssentialsClient.getInventoryControls((Screen)screen).singleTransfer((AbstractContainerScreen<?>)screen, (Slot)slot))).build();
        keyBulkTransfer = Kuma.createKeyMapping((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"inventoryessentials", (String)"bulk_transfer")).withDefault(InputBinding.mouse((int)0, (KeyModifiers)KeyModifiers.of((KeyModifier[])new KeyModifier[]{KeyModifier.SHIFT, KeyModifier.CONTROL}))).handleScreenInput(event -> ModKeyMappings.handleSlotInput(event, () -> InventoryEssentialsConfig.getActive().enableBulkTransfer, (screen, slot) -> InventoryEssentialsClient.getInventoryControls((Screen)screen).bulkTransferByType((AbstractContainerScreen<?>)screen, (Slot)slot))).build();
        keyBulkTransferSingle = Kuma.createKeyMapping((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"inventoryessentials", (String)"bulk_transfer_single")).withDefault(InputBinding.mouse((int)1, (KeyModifiers)KeyModifiers.ofCustom((InputConstants.Key[])new InputConstants.Key[]{InputConstants.getKey((int)32, (int)-1)}))).handleScreenInput(event -> ModKeyMappings.handleSlotInput(event, () -> InventoryEssentialsConfig.getActive().enableBulkTransferSingle, (screen, slot) -> InventoryEssentialsClient.getInventoryControls((Screen)screen).bulkTransferSingle((AbstractContainerScreen<?>)screen, (Slot)slot))).build();
        keyBulkTransferAll = Kuma.createKeyMapping((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"inventoryessentials", (String)"bulk_transfer_all")).withDefault(InputBinding.mouse((int)0, (KeyModifiers)KeyModifiers.ofCustom((InputConstants.Key[])new InputConstants.Key[]{InputConstants.getKey((int)32, (int)-1)}))).handleScreenInput(event -> ModKeyMappings.handleSlotInput(event, () -> InventoryEssentialsConfig.getActive().enableBulkTransferAll, (screen, slot) -> InventoryEssentialsClient.getInventoryControls((Screen)screen).bulkTransferAll((AbstractContainerScreen<?>)screen, (Slot)slot))).build();
        keyBulkDrop = Kuma.createKeyMapping((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"inventoryessentials", (String)"bulk_drop")).withDefault(InputBinding.key((int)81, (KeyModifiers)KeyModifiers.of((KeyModifier[])new KeyModifier[]{KeyModifier.SHIFT, KeyModifier.CONTROL}))).handleScreenInput(event -> ModKeyMappings.handleSlotInput(event, () -> InventoryEssentialsConfig.getActive().enableBulkDrop, (screen, slot) -> InventoryEssentialsClient.getInventoryControls((Screen)screen).dropByType((AbstractContainerScreen<?>)screen, (Slot)slot))).build();
        keyScreenBulkDrop = Kuma.createKeyMapping((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"inventoryessentials", (String)"screen_bulk_drop")).withDefault(InputBinding.mouse((int)0, (KeyModifiers)KeyModifiers.of((KeyModifier[])new KeyModifier[]{KeyModifier.SHIFT}))).handleScreenInput(event -> {
            if (!InventoryEssentialsConfig.getActive().enableBulkDrop) {
                return false;
            }
            if (!InventoryEssentialsClient.shouldHandleInput(event.screen())) {
                return false;
            }
            Screen patt0$temp = event.screen();
            if (!(patt0$temp instanceof AbstractContainerScreen)) {
                return false;
            }
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)patt0$temp;
            AbstractContainerScreenAccessor accessor = (AbstractContainerScreenAccessor)containerScreen;
            int button = keyScreenBulkDrop.getBinding().key().getValue();
            boolean clickedOutside = accessor.callHasClickedOutside(event.mouseX(), event.mouseY(), accessor.getLeftPos(), accessor.getTopPos(), button);
            return clickedOutside && InventoryEssentialsClient.getInventoryControls((Screen)containerScreen).dropByType(containerScreen, containerScreen.getMenu().getCarried());
        }).build();
        keyDragTransfer = Kuma.createKeyMapping((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"inventoryessentials", (String)"drag_transfer")).withDefault(InputBinding.key((int)340)).withContext(KeyConflictContext.SCREEN).forceVirtual().build();
    }

    private static boolean handleSlotInput(ScreenInputEvent event, Supplier<Boolean> predicate, BiFunction<AbstractContainerScreen<?>, Slot, Boolean> handler) {
        if (!predicate.get().booleanValue()) {
            return false;
        }
        if (!InventoryEssentialsClient.shouldHandleInput(event.screen())) {
            return false;
        }
        Screen screen = event.screen();
        if (!(screen instanceof AbstractContainerScreen)) {
            return false;
        }
        AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
        Slot hoverSlot = ((AbstractContainerScreenAccessor)containerScreen).getHoveredSlot();
        if (hoverSlot != null) {
            return handler.apply(containerScreen, hoverSlot);
        }
        return false;
    }
}

