/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.block.BalmBlocks;
import net.blay09.mods.cookingforblockheads.block.CabinetBlock;
import net.blay09.mods.cookingforblockheads.block.ConnectorBlock;
import net.blay09.mods.cookingforblockheads.block.CookingTableBlock;
import net.blay09.mods.cookingforblockheads.block.CounterBlock;
import net.blay09.mods.cookingforblockheads.block.CowJarBlock;
import net.blay09.mods.cookingforblockheads.block.CuttingBoardBlock;
import net.blay09.mods.cookingforblockheads.block.DyedConnectorBlock;
import net.blay09.mods.cookingforblockheads.block.FridgeBlock;
import net.blay09.mods.cookingforblockheads.block.FruitBasketBlock;
import net.blay09.mods.cookingforblockheads.block.KitchenFloorBlock;
import net.blay09.mods.cookingforblockheads.block.MilkJarBlock;
import net.blay09.mods.cookingforblockheads.block.OvenBlock;
import net.blay09.mods.cookingforblockheads.block.SinkBlock;
import net.blay09.mods.cookingforblockheads.block.SpiceRackBlock;
import net.blay09.mods.cookingforblockheads.block.ToasterBlock;
import net.blay09.mods.cookingforblockheads.block.ToolRackBlock;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class ModBlocks {
    public static CookingTableBlock[] dyedCookingTables = new CookingTableBlock[DyeColor.values().length];
    public static CounterBlock[] dyedCounters = new CounterBlock[DyeColor.values().length];
    public static CabinetBlock[] dyedCabinets = new CabinetBlock[DyeColor.values().length];
    public static OvenBlock[] ovens = new OvenBlock[DyeColor.values().length];
    public static CookingTableBlock cookingTable;
    public static Block toolRack;
    public static Block toaster;
    public static Block milkJar;
    public static Block cowJar;
    public static Block spiceRack;
    public static Block fruitBasket;
    public static Block cuttingBoard;
    public static FridgeBlock[] fridges;
    public static SinkBlock sink;
    public static SinkBlock[] dyedSinks;
    public static CounterBlock counter;
    public static CabinetBlock cabinet;
    public static Block connector;
    public static DyedConnectorBlock[] dyedConnectors;
    public static Block[] kitchenFloors;

    public static void initialize(BalmBlocks blocks) {
        String colorPrefix;
        blocks.register(() -> {
            toolRack = new ToolRackBlock(ModBlocks.defaultProperties());
            return toolRack;
        }, () -> ModBlocks.itemBlock(toolRack), ModBlocks.id("tool_rack"));
        blocks.register(() -> {
            toaster = new ToasterBlock(ModBlocks.defaultProperties());
            return toaster;
        }, () -> ModBlocks.itemBlock(toaster), ModBlocks.id("toaster"));
        blocks.register(() -> {
            milkJar = new MilkJarBlock(ModBlocks.defaultProperties());
            return milkJar;
        }, () -> ModBlocks.itemBlock(milkJar), ModBlocks.id("milk_jar"));
        blocks.register(() -> {
            cowJar = new CowJarBlock(ModBlocks.defaultProperties());
            return cowJar;
        }, () -> ModBlocks.itemBlock(cowJar), ModBlocks.id("cow_jar"));
        blocks.register(() -> {
            spiceRack = new SpiceRackBlock(ModBlocks.defaultProperties());
            return spiceRack;
        }, () -> ModBlocks.itemBlock(spiceRack), ModBlocks.id("spice_rack"));
        blocks.register(() -> {
            fruitBasket = new FruitBasketBlock(ModBlocks.defaultProperties());
            return fruitBasket;
        }, () -> ModBlocks.itemBlock(fruitBasket), ModBlocks.id("fruit_basket"));
        blocks.register(() -> {
            cuttingBoard = new CuttingBoardBlock(ModBlocks.defaultProperties());
            return cuttingBoard;
        }, () -> ModBlocks.itemBlock(cuttingBoard), ModBlocks.id("cutting_board"));
        DyeColor[] colors = DyeColor.values();
        kitchenFloors = new Block[colors.length];
        ovens = new OvenBlock[colors.length];
        dyedCookingTables = new CookingTableBlock[colors.length];
        dyedConnectors = new DyedConnectorBlock[colors.length];
        for (DyeColor color : colors) {
            colorPrefix = color.getSerializedName() + "_";
            blocks.register(() -> {
                OvenBlock ovenBlock = new OvenBlock(color, ModBlocks.defaultProperties());
                ModBlocks.ovens[color.ordinal()] = ovenBlock;
                return ovenBlock;
            }, () -> ModBlocks.itemBlock((Block)ovens[color.ordinal()]), ModBlocks.id(colorPrefix + "oven"));
        }
        for (DyeColor color : colors) {
            colorPrefix = color.getSerializedName() + "_";
            blocks.register(() -> {
                FridgeBlock fridgeBlock = new FridgeBlock(color, ModBlocks.defaultProperties());
                ModBlocks.fridges[color.ordinal()] = fridgeBlock;
                return fridgeBlock;
            }, () -> ModBlocks.itemBlock((Block)fridges[color.ordinal()]), ModBlocks.id(colorPrefix + "fridge"));
        }
        blocks.register(() -> {
            connector = new ConnectorBlock(ModBlocks.defaultProperties());
            return connector;
        }, () -> ModBlocks.itemBlock(connector), ModBlocks.id("connector"));
        for (DyeColor color : colors) {
            colorPrefix = color.getSerializedName() + "_";
            blocks.register(() -> {
                DyedConnectorBlock dyedConnectorBlock = new DyedConnectorBlock(color, ModBlocks.defaultProperties());
                ModBlocks.dyedConnectors[color.ordinal()] = dyedConnectorBlock;
                return dyedConnectorBlock;
            }, () -> ModBlocks.itemBlock((Block)dyedConnectors[color.ordinal()]), ModBlocks.id(colorPrefix + "connector"));
        }
        for (DyeColor color : colors) {
            colorPrefix = color.getSerializedName() + "_";
            blocks.register(() -> {
                KitchenFloorBlock kitchenFloorBlock = new KitchenFloorBlock(ModBlocks.defaultProperties());
                ModBlocks.kitchenFloors[color.ordinal()] = kitchenFloorBlock;
                return kitchenFloorBlock;
            }, () -> ModBlocks.itemBlock(kitchenFloors[color.ordinal()]), ModBlocks.id(colorPrefix + "kitchen_floor"));
        }
        blocks.register(() -> {
            cookingTable = new CookingTableBlock(null, ModBlocks.defaultProperties());
            return cookingTable;
        }, () -> ModBlocks.itemBlock((Block)cookingTable), ModBlocks.id("cooking_table"));
        for (DyeColor color : colors) {
            colorPrefix = color.getSerializedName() + "_";
            blocks.register(() -> {
                CookingTableBlock cookingTableBlock = new CookingTableBlock(color, ModBlocks.defaultProperties());
                ModBlocks.dyedCookingTables[color.ordinal()] = cookingTableBlock;
                return cookingTableBlock;
            }, () -> ModBlocks.itemBlock((Block)dyedCookingTables[color.ordinal()]), ModBlocks.id(colorPrefix + "cooking_table"));
        }
        blocks.register(() -> {
            counter = new CounterBlock(null, ModBlocks.defaultProperties());
            return counter;
        }, () -> ModBlocks.itemBlock((Block)counter), ModBlocks.id("counter"));
        for (DyeColor color : colors) {
            colorPrefix = color.getSerializedName() + "_";
            blocks.register(() -> {
                CounterBlock counterBlock = new CounterBlock(color, ModBlocks.defaultProperties());
                ModBlocks.dyedCounters[color.ordinal()] = counterBlock;
                return counterBlock;
            }, () -> ModBlocks.itemBlock((Block)dyedCounters[color.ordinal()]), ModBlocks.id(colorPrefix + "counter"));
        }
        blocks.register(() -> {
            cabinet = new CabinetBlock(null, ModBlocks.defaultProperties());
            return cabinet;
        }, () -> ModBlocks.itemBlock((Block)cabinet), ModBlocks.id("cabinet"));
        for (DyeColor color : colors) {
            colorPrefix = color.getSerializedName() + "_";
            blocks.register(() -> {
                CabinetBlock cabinetBlock = new CabinetBlock(color, ModBlocks.defaultProperties());
                ModBlocks.dyedCabinets[color.ordinal()] = cabinetBlock;
                return cabinetBlock;
            }, () -> ModBlocks.itemBlock((Block)dyedCabinets[color.ordinal()]), ModBlocks.id(colorPrefix + "cabinet"));
        }
        blocks.register(() -> {
            sink = new SinkBlock(null, ModBlocks.defaultProperties());
            return sink;
        }, () -> ModBlocks.itemBlock((Block)sink), ModBlocks.id("sink"));
        for (DyeColor color : colors) {
            colorPrefix = color.getSerializedName() + "_";
            blocks.register(() -> {
                SinkBlock sinkBlock = new SinkBlock(color, ModBlocks.defaultProperties());
                ModBlocks.dyedSinks[color.ordinal()] = sinkBlock;
                return sinkBlock;
            }, () -> ModBlocks.itemBlock((Block)dyedSinks[color.ordinal()]), ModBlocks.id(colorPrefix + "sink"));
        }
    }

    private static BlockItem itemBlock(Block block) {
        return new BlockItem(block, Balm.getItems().itemProperties());
    }

    private static ResourceLocation id(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"cookingforblockheads", (String)name);
    }

    private static BlockBehaviour.Properties defaultProperties() {
        return Balm.getBlocks().blockProperties();
    }

    static {
        fridges = new FridgeBlock[DyeColor.values().length];
        dyedSinks = new SinkBlock[DyeColor.values().length];
        dyedConnectors = new DyedConnectorBlock[DyeColor.values().length];
        kitchenFloors = new Block[DyeColor.values().length];
    }
}

