/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge;

import com.refinedmods.refinedstorage.api.resource.repository.SortingDirection;
import com.refinedmods.refinedstorage.common.Config;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.AutocrafterManagerSearchMode;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.AutocrafterManagerViewType;
import com.refinedmods.refinedstorage.common.grid.CraftingGridMatrixCloseBehavior;
import com.refinedmods.refinedstorage.common.grid.GridSortingTypes;
import com.refinedmods.refinedstorage.common.grid.GridViewType;
import com.refinedmods.refinedstorage.common.support.stretching.ScreenSize;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ConfigImpl
implements Config {
    private static final String ENERGY_USAGE = "energyUsage";
    private static final String ENERGY_CAPACITY = "energyCapacity";
    private static final String OPEN_ENERGY_USAGE = "openEnergyUsage";
    private final ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
    private final ModConfigSpec spec;
    private final ModConfigSpec.EnumValue<ScreenSize> screenSize = this.builder.translation(ConfigImpl.translationKey("screenSize")).defineEnum("screenSize", (Enum)ScreenSize.STRETCH);
    private final ModConfigSpec.BooleanValue smoothScrolling = this.builder.translation(ConfigImpl.translationKey("smoothScrolling")).define("smoothScrolling", true);
    private final ModConfigSpec.IntValue maxRowsStretch = this.builder.translation(ConfigImpl.translationKey("maxRowsStretch")).defineInRange("maxRowsStretch", 256, 3, 256);
    private final ModConfigSpec.BooleanValue searchBoxAutoSelected = this.builder.translation(ConfigImpl.translationKey("searchBoxAutoSelected")).define("searchBoxAutoSelected", false);
    private final ModConfigSpec.BooleanValue autocraftingNotification = this.builder.translation(ConfigImpl.translationKey("autocraftingNotification")).define("autocraftingNotification", true);
    private final Config.SimpleEnergyUsageEntry cable = new SimpleEnergyUsageEntryImpl(this, "cable", 0L);
    private final Config.ControllerEntry controller = new ControllerEntryImpl(this);
    private final Config.DiskDriveEntry diskDrive = new DiskDriveEntryImpl(this);
    private final Config.DiskInterfaceEntry diskInterface = new DiskInterfaceEntryImpl(this);
    private final Config.GridEntry grid = new GridEntryImpl();
    private final Config.CraftingGridEntry craftingGrid = new CraftingGridEntryImpl(this);
    private final Config.SimpleEnergyUsageEntry patternGrid = new SimpleEnergyUsageEntryImpl(this, "patternGrid", 14L);
    private final Config.StorageBlockEntry storageBlock = new StorageBlockEntryImpl(this);
    private final Config.FluidStorageBlockEntry fluidStorageBlock = new FluidStorageBlockEntryImpl(this);
    private final Config.SimpleEnergyUsageEntry importer = new SimpleEnergyUsageEntryImpl(this, "importer", 2L);
    private final Config.SimpleEnergyUsageEntry exporter = new SimpleEnergyUsageEntryImpl(this, "exporter", 2L);
    private final Config.UpgradeEntry upgrade = new UpgradeEntryImpl(this);
    private final Config.SimpleEnergyUsageEntry iface = new SimpleEnergyUsageEntryImpl(this, "interface", 4L);
    private final Config.SimpleEnergyUsageEntry externalStorage = new SimpleEnergyUsageEntryImpl(this, "externalStorage", 6L);
    private final Config.SimpleEnergyUsageEntry detector = new SimpleEnergyUsageEntryImpl(this, "detector", 2L);
    private final Config.SimpleEnergyUsageEntry destructor = new SimpleEnergyUsageEntryImpl(this, "destructor", 3L);
    private final Config.SimpleEnergyUsageEntry constructor = new SimpleEnergyUsageEntryImpl(this, "constructor", 3L);
    private final Config.WirelessGridEntry wirelessGrid = new WirelessGridEntryImpl(this);
    private final Config.WirelessTransmitterEntry wirelessTransmitter = new WirelessTransmitterEntryImpl(this);
    private final Config.SimpleEnergyUsageEntry storageMonitor = new SimpleEnergyUsageEntryImpl(this, "storageMonitor", 4L);
    private final Config.SimpleEnergyUsageEntry networkReceiver = new SimpleEnergyUsageEntryImpl(this, "networkReceiver", 8L);
    private final Config.SimpleEnergyUsageEntry networkTransmitter = new SimpleEnergyUsageEntryImpl(this, "networkTransmitter", 32L);
    private final Config.PortableGridEntry portableGrid = new PortableGridEntryImpl(this);
    private final Config.SimpleEnergyUsageEntry securityCard = new SimpleEnergyUsageEntryImpl(this, "securityCard", 2L);
    private final Config.SimpleEnergyUsageEntry fallbackSecurityCard = new SimpleEnergyUsageEntryImpl(this, "fallbackSecurityCard", 4L);
    private final Config.SimpleEnergyUsageEntry securityManager = new SimpleEnergyUsageEntryImpl(this, "securityManager", 16L);
    private final Config.RelayEntry relay = new RelayEntryImpl(this);
    private final AutocrafterEntryImpl autocrafter = new AutocrafterEntryImpl(this);
    private final AutocrafterManagerEntryImpl autocrafterManager = new AutocrafterManagerEntryImpl();
    private final Config.SimpleEnergyUsageEntry autocraftingMonitor = new SimpleEnergyUsageEntryImpl(this, "autocraftingMonitor", 16L);
    private final WirelessAutocraftingMonitorEntryImpl wirelessAutocraftingMonitor = new WirelessAutocraftingMonitorEntryImpl(this);

    public ConfigImpl() {
        this.spec = this.builder.build();
    }

    public ModConfigSpec getSpec() {
        return this.spec;
    }

    @Override
    public ScreenSize getScreenSize() {
        return (ScreenSize)((Object)this.screenSize.get());
    }

    @Override
    public boolean isSmoothScrolling() {
        return (Boolean)this.smoothScrolling.get();
    }

    @Override
    public int getMaxRowsStretch() {
        return (Integer)this.maxRowsStretch.get();
    }

    @Override
    public boolean isAutocraftingNotification() {
        return (Boolean)this.autocraftingNotification.get();
    }

    @Override
    public void setAutocraftingNotification(boolean autocraftingNotification) {
        if (autocraftingNotification != Boolean.TRUE.equals(this.autocraftingNotification.get())) {
            this.autocraftingNotification.set((Object)autocraftingNotification);
            this.spec.save();
        }
    }

    @Override
    public void setScreenSize(ScreenSize screenSize) {
        if (screenSize != this.screenSize.get()) {
            this.screenSize.set((Object)screenSize);
            this.spec.save();
        }
    }

    @Override
    public boolean isSearchBoxAutoSelected() {
        return (Boolean)this.searchBoxAutoSelected.get();
    }

    @Override
    public void setSearchBoxAutoSelected(boolean searchBoxAutoSelected) {
        if (searchBoxAutoSelected != Boolean.TRUE.equals(this.searchBoxAutoSelected.get())) {
            this.searchBoxAutoSelected.set((Object)searchBoxAutoSelected);
            this.spec.save();
        }
    }

    @Override
    public Config.GridEntry getGrid() {
        return this.grid;
    }

    @Override
    public Config.SimpleEnergyUsageEntry getPatternGrid() {
        return this.patternGrid;
    }

    @Override
    public Config.CraftingGridEntry getCraftingGrid() {
        return this.craftingGrid;
    }

    @Override
    public Config.ControllerEntry getController() {
        return this.controller;
    }

    @Override
    public Config.DiskDriveEntry getDiskDrive() {
        return this.diskDrive;
    }

    @Override
    public Config.DiskInterfaceEntry getDiskInterface() {
        return this.diskInterface;
    }

    @Override
    public Config.SimpleEnergyUsageEntry getCable() {
        return this.cable;
    }

    @Override
    public Config.StorageBlockEntry getStorageBlock() {
        return this.storageBlock;
    }

    @Override
    public Config.FluidStorageBlockEntry getFluidStorageBlock() {
        return this.fluidStorageBlock;
    }

    @Override
    public Config.SimpleEnergyUsageEntry getImporter() {
        return this.importer;
    }

    @Override
    public Config.SimpleEnergyUsageEntry getExporter() {
        return this.exporter;
    }

    @Override
    public Config.UpgradeEntry getUpgrade() {
        return this.upgrade;
    }

    @Override
    public Config.SimpleEnergyUsageEntry getInterface() {
        return this.iface;
    }

    @Override
    public Config.SimpleEnergyUsageEntry getExternalStorage() {
        return this.externalStorage;
    }

    @Override
    public Config.SimpleEnergyUsageEntry getDetector() {
        return this.detector;
    }

    @Override
    public Config.SimpleEnergyUsageEntry getDestructor() {
        return this.destructor;
    }

    @Override
    public Config.SimpleEnergyUsageEntry getConstructor() {
        return this.constructor;
    }

    @Override
    public Config.WirelessGridEntry getWirelessGrid() {
        return this.wirelessGrid;
    }

    @Override
    public Config.WirelessTransmitterEntry getWirelessTransmitter() {
        return this.wirelessTransmitter;
    }

    @Override
    public Config.SimpleEnergyUsageEntry getStorageMonitor() {
        return this.storageMonitor;
    }

    @Override
    public Config.SimpleEnergyUsageEntry getNetworkReceiver() {
        return this.networkReceiver;
    }

    @Override
    public Config.SimpleEnergyUsageEntry getNetworkTransmitter() {
        return this.networkTransmitter;
    }

    @Override
    public Config.PortableGridEntry getPortableGrid() {
        return this.portableGrid;
    }

    @Override
    public Config.SimpleEnergyUsageEntry getSecurityCard() {
        return this.securityCard;
    }

    @Override
    public Config.SimpleEnergyUsageEntry getFallbackSecurityCard() {
        return this.fallbackSecurityCard;
    }

    @Override
    public Config.SimpleEnergyUsageEntry getSecurityManager() {
        return this.securityManager;
    }

    @Override
    public Config.RelayEntry getRelay() {
        return this.relay;
    }

    @Override
    public Config.AutocrafterEntry getAutocrafter() {
        return this.autocrafter;
    }

    @Override
    public Config.AutocrafterManagerEntry getAutocrafterManager() {
        return this.autocrafterManager;
    }

    @Override
    public Config.SimpleEnergyUsageEntry getAutocraftingMonitor() {
        return this.autocraftingMonitor;
    }

    @Override
    public Config.WirelessAutocraftingMonitorEntry getWirelessAutocraftingMonitor() {
        return this.wirelessAutocraftingMonitor;
    }

    private static String translationKey(String value) {
        return IdentifierUtil.createTranslationKey("text.autoconfig", "option." + value);
    }

    private class SimpleEnergyUsageEntryImpl
    implements Config.SimpleEnergyUsageEntry {
        private final ModConfigSpec.LongValue energyUsage;

        SimpleEnergyUsageEntryImpl(ConfigImpl configImpl, String path, long defaultValue) {
            String correctedPath = "interface".equals(path) ? "iface" : path;
            configImpl.builder.translation(ConfigImpl.translationKey(correctedPath)).push(path);
            this.energyUsage = configImpl.builder.translation(ConfigImpl.translationKey(correctedPath + ".energyUsage")).defineInRange(ConfigImpl.ENERGY_USAGE, defaultValue, 0L, Long.MAX_VALUE);
            configImpl.builder.pop();
        }

        @Override
        public long getEnergyUsage() {
            return (Long)this.energyUsage.get();
        }
    }

    private class ControllerEntryImpl
    implements Config.ControllerEntry {
        private final ModConfigSpec.LongValue energyCapacity;

        private ControllerEntryImpl(ConfigImpl configImpl) {
            configImpl.builder.translation(ConfigImpl.translationKey("controller")).push("controller");
            this.energyCapacity = configImpl.builder.translation(ConfigImpl.translationKey("controller.energyCapacity")).defineInRange(ConfigImpl.ENERGY_CAPACITY, 1000L, 0L, Long.MAX_VALUE);
            configImpl.builder.pop();
        }

        @Override
        public long getEnergyCapacity() {
            return (Long)this.energyCapacity.get();
        }
    }

    private class DiskDriveEntryImpl
    implements Config.DiskDriveEntry {
        private final ModConfigSpec.LongValue energyUsage;
        private final ModConfigSpec.LongValue energyUsagePerDisk;

        private DiskDriveEntryImpl(ConfigImpl configImpl) {
            configImpl.builder.translation(ConfigImpl.translationKey("diskDrive")).push("diskDrive");
            this.energyUsage = configImpl.builder.translation(ConfigImpl.translationKey("diskDrive.energyUsage")).defineInRange(ConfigImpl.ENERGY_USAGE, 10L, 0L, Long.MAX_VALUE);
            this.energyUsagePerDisk = configImpl.builder.translation(ConfigImpl.translationKey("diskDrive.energyUsagePerDisk")).defineInRange("energyUsagePerDisk", 4L, 0L, Long.MAX_VALUE);
            configImpl.builder.pop();
        }

        @Override
        public long getEnergyUsage() {
            return (Long)this.energyUsage.get();
        }

        @Override
        public long getEnergyUsagePerDisk() {
            return (Long)this.energyUsagePerDisk.get();
        }
    }

    private class DiskInterfaceEntryImpl
    implements Config.DiskInterfaceEntry {
        private final ModConfigSpec.LongValue energyUsage;
        private final ModConfigSpec.LongValue energyUsagePerDisk;

        private DiskInterfaceEntryImpl(ConfigImpl configImpl) {
            configImpl.builder.translation(ConfigImpl.translationKey("diskInterface")).push("diskInterface");
            this.energyUsage = configImpl.builder.translation(ConfigImpl.translationKey("diskInterface.energyUsage")).defineInRange(ConfigImpl.ENERGY_USAGE, 6L, 0L, Long.MAX_VALUE);
            this.energyUsagePerDisk = configImpl.builder.translation(ConfigImpl.translationKey("diskInterface.energyUsagePerDisk")).defineInRange("energyUsagePerDisk", 4L, 0L, Long.MAX_VALUE);
            configImpl.builder.pop();
        }

        @Override
        public long getEnergyUsage() {
            return (Long)this.energyUsage.get();
        }

        @Override
        public long getEnergyUsagePerDisk() {
            return (Long)this.energyUsagePerDisk.get();
        }
    }

    private class GridEntryImpl
    implements Config.GridEntry {
        private final ModConfigSpec.BooleanValue largeFont;
        private final ModConfigSpec.BooleanValue preventSortingWhileShiftIsDown;
        private final ModConfigSpec.BooleanValue detailedTooltip;
        private final ModConfigSpec.BooleanValue rememberSearchQuery;
        private final ModConfigSpec.LongValue energyUsage;
        private final ModConfigSpec.ConfigValue<String> synchronizer;
        private final ModConfigSpec.ConfigValue<String> resourceType;
        private final ModConfigSpec.EnumValue<SortingDirection> sortingDirection;
        private final ModConfigSpec.EnumValue<GridSortingTypes> sortingType;
        private final ModConfigSpec.EnumValue<GridViewType> viewType;

        GridEntryImpl() {
            ConfigImpl.this.builder.translation(ConfigImpl.translationKey("grid")).push("grid");
            this.largeFont = ConfigImpl.this.builder.translation(ConfigImpl.translationKey("grid.largeFont")).define("largeFont", false);
            this.preventSortingWhileShiftIsDown = ConfigImpl.this.builder.translation(ConfigImpl.translationKey("grid.preventSortingWhileShiftIsDown")).define("preventSortingWhileShiftIsDown", true);
            this.detailedTooltip = ConfigImpl.this.builder.translation(ConfigImpl.translationKey("grid.detailedTooltip")).define("detailedTooltip", true);
            this.rememberSearchQuery = ConfigImpl.this.builder.translation(ConfigImpl.translationKey("grid.rememberSearchQuery")).define("rememberSearchQuery", false);
            this.energyUsage = ConfigImpl.this.builder.translation(ConfigImpl.translationKey("grid.energyUsage")).defineInRange(ConfigImpl.ENERGY_USAGE, 10L, 0L, Long.MAX_VALUE);
            this.synchronizer = ConfigImpl.this.builder.translation(ConfigImpl.translationKey("grid.synchronizer")).define("synchronizer", (Object)"");
            this.resourceType = ConfigImpl.this.builder.translation(ConfigImpl.translationKey("grid.resourceType")).define("resourceType", (Object)"");
            this.sortingDirection = ConfigImpl.this.builder.translation(ConfigImpl.translationKey("grid.sortingDirection")).defineEnum("sortingDirection", (Enum)SortingDirection.ASCENDING);
            this.sortingType = ConfigImpl.this.builder.translation(ConfigImpl.translationKey("grid.sortingType")).defineEnum("sortingType", (Enum)GridSortingTypes.QUANTITY);
            this.viewType = ConfigImpl.this.builder.translation(ConfigImpl.translationKey("grid.viewType")).defineEnum("viewType", (Enum)GridViewType.ALL);
            ConfigImpl.this.builder.pop();
        }

        @Override
        public boolean isLargeFont() {
            return (Boolean)this.largeFont.get();
        }

        @Override
        public boolean isPreventSortingWhileShiftIsDown() {
            return (Boolean)this.preventSortingWhileShiftIsDown.get();
        }

        @Override
        public boolean isDetailedTooltip() {
            return (Boolean)this.detailedTooltip.get();
        }

        @Override
        public boolean isRememberSearchQuery() {
            return (Boolean)this.rememberSearchQuery.get();
        }

        @Override
        public long getEnergyUsage() {
            return (Long)this.energyUsage.get();
        }

        @Override
        public Optional<ResourceLocation> getSynchronizer() {
            if (((String)this.synchronizer.get()).trim().isBlank()) {
                return Optional.empty();
            }
            return Optional.of((String)this.synchronizer.get()).map(ResourceLocation::tryParse);
        }

        @Override
        public void setSynchronizer(ResourceLocation synchronizerId) {
            if (!synchronizerId.toString().equals(this.synchronizer.get())) {
                this.synchronizer.set((Object)synchronizerId.toString());
                ConfigImpl.this.spec.save();
            }
        }

        @Override
        public void clearSynchronizer() {
            if (!((String)this.synchronizer.get()).isEmpty()) {
                this.synchronizer.set((Object)"");
                ConfigImpl.this.spec.save();
            }
        }

        @Override
        public SortingDirection getSortingDirection() {
            return (SortingDirection)((Object)this.sortingDirection.get());
        }

        @Override
        public void setSortingDirection(SortingDirection sortingDirection) {
            if (sortingDirection != this.sortingDirection.get()) {
                this.sortingDirection.set((Object)sortingDirection);
                ConfigImpl.this.spec.save();
            }
        }

        @Override
        public GridSortingTypes getSortingType() {
            return (GridSortingTypes)((Object)this.sortingType.get());
        }

        @Override
        public void setSortingType(GridSortingTypes sortingType) {
            if (sortingType != this.sortingType.get()) {
                this.sortingType.set((Object)sortingType);
                ConfigImpl.this.spec.save();
            }
        }

        @Override
        public GridViewType getViewType() {
            return (GridViewType)((Object)this.viewType.get());
        }

        @Override
        public void setViewType(GridViewType viewType) {
            if (viewType != this.viewType.get()) {
                this.viewType.set((Object)viewType);
                ConfigImpl.this.spec.save();
            }
        }

        @Override
        public Optional<ResourceLocation> getResourceType() {
            if (((String)this.resourceType.get()).trim().isBlank()) {
                return Optional.empty();
            }
            return Optional.of((String)this.resourceType.get()).map(ResourceLocation::tryParse);
        }

        @Override
        public void setResourceType(ResourceLocation resourceTypeId) {
            if (!resourceTypeId.toString().equals(this.resourceType.get())) {
                this.resourceType.set((Object)resourceTypeId.toString());
                ConfigImpl.this.spec.save();
            }
        }

        @Override
        public void clearResourceType() {
            if (!((String)this.resourceType.get()).isEmpty()) {
                this.resourceType.set((Object)"");
                ConfigImpl.this.spec.save();
            }
        }
    }

    private class CraftingGridEntryImpl
    implements Config.CraftingGridEntry {
        private final ModConfigSpec.LongValue energyUsage;
        private final ModConfigSpec.EnumValue<CraftingGridMatrixCloseBehavior> craftingMatrixCloseBehavior;

        CraftingGridEntryImpl(ConfigImpl configImpl) {
            configImpl.builder.translation(ConfigImpl.translationKey("craftingGrid")).push("craftingGrid");
            this.energyUsage = configImpl.builder.translation(ConfigImpl.translationKey("craftingGrid.energyUsage")).defineInRange(ConfigImpl.ENERGY_USAGE, 14L, 0L, Long.MAX_VALUE);
            this.craftingMatrixCloseBehavior = configImpl.builder.translation(ConfigImpl.translationKey("craftingGrid.craftingMatrixCloseBehavior")).defineEnum("craftingMatrixCloseBehavior", (Enum)CraftingGridMatrixCloseBehavior.NONE);
            configImpl.builder.pop();
        }

        @Override
        public long getEnergyUsage() {
            return (Long)this.energyUsage.get();
        }

        @Override
        public CraftingGridMatrixCloseBehavior getCraftingMatrixCloseBehavior() {
            return (CraftingGridMatrixCloseBehavior)((Object)this.craftingMatrixCloseBehavior.get());
        }
    }

    private class StorageBlockEntryImpl
    implements Config.StorageBlockEntry {
        private final ModConfigSpec.LongValue oneKEnergyUsage;
        private final ModConfigSpec.LongValue fourKEnergyUsage;
        private final ModConfigSpec.LongValue sixteenKEnergyUsage;
        private final ModConfigSpec.LongValue sixtyFourKEnergyUsage;
        private final ModConfigSpec.LongValue creativeEnergyUsage;

        StorageBlockEntryImpl(ConfigImpl configImpl) {
            configImpl.builder.translation(ConfigImpl.translationKey("storageBlock")).push("storageBlock");
            this.oneKEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("storageBlock.oneKEnergyUsage")).defineInRange("1kEnergyUsage", 2L, 0L, Long.MAX_VALUE);
            this.fourKEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("storageBlock.fourKEnergyUsage")).defineInRange("4kEnergyUsage", 4L, 0L, Long.MAX_VALUE);
            this.sixteenKEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("storageBlock.sixteenKEnergyUsage")).defineInRange("16kEnergyUsage", 6L, 0L, Long.MAX_VALUE);
            this.sixtyFourKEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("storageBlock.sixtyFourKEnergyUsage")).defineInRange("64kEnergyUsage", 8L, 0L, Long.MAX_VALUE);
            this.creativeEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("storageBlock.creativeEnergyUsage")).defineInRange("creativeEnergyUsage", 16L, 0L, Long.MAX_VALUE);
            configImpl.builder.pop();
        }

        @Override
        public long get1kEnergyUsage() {
            return (Long)this.oneKEnergyUsage.get();
        }

        @Override
        public long get4kEnergyUsage() {
            return (Long)this.fourKEnergyUsage.get();
        }

        @Override
        public long get16kEnergyUsage() {
            return (Long)this.sixteenKEnergyUsage.get();
        }

        @Override
        public long get64kEnergyUsage() {
            return (Long)this.sixtyFourKEnergyUsage.get();
        }

        @Override
        public long getCreativeEnergyUsage() {
            return (Long)this.creativeEnergyUsage.get();
        }
    }

    private class FluidStorageBlockEntryImpl
    implements Config.FluidStorageBlockEntry {
        private final ModConfigSpec.LongValue sixtyFourBEnergyUsage;
        private final ModConfigSpec.LongValue twoHundredFiftySixBEnergyUsage;
        private final ModConfigSpec.LongValue thousandTwentyFourBEnergyUsage;
        private final ModConfigSpec.LongValue fourThousandNinetySixBEnergyUsage;
        private final ModConfigSpec.LongValue creativeEnergyUsage;

        FluidStorageBlockEntryImpl(ConfigImpl configImpl) {
            configImpl.builder.translation(ConfigImpl.translationKey("fluidStorageBlock")).push("fluidStorageBlock");
            this.sixtyFourBEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("fluidStorageBlock.sixtyFourBEnergyUsage")).defineInRange("64bEnergyUsage", 2L, 0L, Long.MAX_VALUE);
            this.twoHundredFiftySixBEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("fluidStorageBlock.twoHundredFiftySixBEnergyUsage")).defineInRange("256bEnergyUsage", 4L, 0L, Long.MAX_VALUE);
            this.thousandTwentyFourBEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("fluidStorageBlock.thousandTwentyFourBEnergyUsage")).defineInRange("1024bEnergyUsage", 6L, 0L, Long.MAX_VALUE);
            this.fourThousandNinetySixBEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("fluidStorageBlock.fourThousandNinetySixBEnergyUsage")).defineInRange("4096bEnergyUsage", 8L, 0L, Long.MAX_VALUE);
            this.creativeEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("fluidStorageBlock.creativeEnergyUsage")).defineInRange("creativeEnergyUsage", 16L, 0L, Long.MAX_VALUE);
            configImpl.builder.pop();
        }

        @Override
        public long get64bEnergyUsage() {
            return (Long)this.sixtyFourBEnergyUsage.get();
        }

        @Override
        public long get256bEnergyUsage() {
            return (Long)this.twoHundredFiftySixBEnergyUsage.get();
        }

        @Override
        public long get1024bEnergyUsage() {
            return (Long)this.thousandTwentyFourBEnergyUsage.get();
        }

        @Override
        public long get4096bEnergyUsage() {
            return (Long)this.fourThousandNinetySixBEnergyUsage.get();
        }

        @Override
        public long getCreativeEnergyUsage() {
            return (Long)this.creativeEnergyUsage.get();
        }
    }

    private class UpgradeEntryImpl
    implements Config.UpgradeEntry {
        private final ModConfigSpec.LongValue speedUpgradeEnergyUsage;
        private final ModConfigSpec.LongValue stackUpgradeEnergyUsage;
        private final ModConfigSpec.LongValue fortune1UpgradeEnergyUsage;
        private final ModConfigSpec.LongValue fortune2UpgradeEnergyUsage;
        private final ModConfigSpec.LongValue fortune3UpgradeEnergyUsage;
        private final ModConfigSpec.LongValue silkTouchUpgradeEnergyUsage;
        private final ModConfigSpec.LongValue regulatorUpgradeEnergyUsage;
        private final ModConfigSpec.LongValue rangeUpgradeEnergyUsage;
        private final ModConfigSpec.LongValue creativeRangeUpgradeEnergyUsage;
        private final ModConfigSpec.IntValue rangeUpgradeRange;
        private final ModConfigSpec.LongValue autocraftingUpgradeUsage;

        UpgradeEntryImpl(ConfigImpl configImpl) {
            configImpl.builder.translation(ConfigImpl.translationKey("upgrade")).push("upgrade");
            this.speedUpgradeEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("upgrade.speedUpgradeEnergyUsage")).defineInRange("speedUpgradeEnergyUsage", 4L, 0L, Long.MAX_VALUE);
            this.stackUpgradeEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("upgrade.stackUpgradeEnergyUsage")).defineInRange("stackUpgradeEnergyUsage", 16L, 0L, Long.MAX_VALUE);
            this.fortune1UpgradeEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("upgrade.fortune1UpgradeEnergyUsage")).defineInRange("fortune1UpgradeEnergyUsage", 10L, 0L, Long.MAX_VALUE);
            this.fortune2UpgradeEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("upgrade.fortune2UpgradeEnergyUsage")).defineInRange("fortune2UpgradeEnergyUsage", 12L, 0L, Long.MAX_VALUE);
            this.fortune3UpgradeEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("upgrade.fortune3UpgradeEnergyUsage")).defineInRange("fortune3UpgradeEnergyUsage", 14L, 0L, Long.MAX_VALUE);
            this.silkTouchUpgradeEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("upgrade.silkTouchUpgradeEnergyUsage")).defineInRange("silkTouchUpgradeEnergyUsage", 16L, 0L, Long.MAX_VALUE);
            this.regulatorUpgradeEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("upgrade.regulatorUpgradeEnergyUsage")).defineInRange("regulatorUpgradeEnergyUsage", 16L, 0L, Long.MAX_VALUE);
            this.rangeUpgradeEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("upgrade.rangeUpgradeEnergyUsage")).defineInRange("rangeUpgradeEnergyUsage", 8L, 0L, Long.MAX_VALUE);
            this.creativeRangeUpgradeEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("upgrade.creativeRangeUpgradeEnergyUsage")).defineInRange("creativeRangeUpgradeEnergyUsage", 0L, 0L, Long.MAX_VALUE);
            this.rangeUpgradeRange = configImpl.builder.translation(ConfigImpl.translationKey("upgrade.rangeUpgradeRange")).defineInRange("rangeUpgradeRange", 8, 0, Integer.MAX_VALUE);
            this.autocraftingUpgradeUsage = configImpl.builder.translation(ConfigImpl.translationKey("upgrade.autocraftingUpgradeUsage")).defineInRange("autocraftingUpgradeUsage", 8L, 0L, Long.MAX_VALUE);
            configImpl.builder.pop();
        }

        @Override
        public long getSpeedUpgradeEnergyUsage() {
            return (Long)this.speedUpgradeEnergyUsage.get();
        }

        @Override
        public long getStackUpgradeEnergyUsage() {
            return (Long)this.stackUpgradeEnergyUsage.get();
        }

        @Override
        public long getFortune1UpgradeEnergyUsage() {
            return (Long)this.fortune1UpgradeEnergyUsage.get();
        }

        @Override
        public long getFortune2UpgradeEnergyUsage() {
            return (Long)this.fortune2UpgradeEnergyUsage.get();
        }

        @Override
        public long getFortune3UpgradeEnergyUsage() {
            return (Long)this.fortune3UpgradeEnergyUsage.get();
        }

        @Override
        public long getSilkTouchUpgradeEnergyUsage() {
            return (Long)this.silkTouchUpgradeEnergyUsage.get();
        }

        @Override
        public long getRegulatorUpgradeEnergyUsage() {
            return (Long)this.regulatorUpgradeEnergyUsage.get();
        }

        @Override
        public long getRangeUpgradeEnergyUsage() {
            return (Long)this.rangeUpgradeEnergyUsage.get();
        }

        @Override
        public long getCreativeRangeUpgradeEnergyUsage() {
            return (Long)this.creativeRangeUpgradeEnergyUsage.get();
        }

        @Override
        public int getRangeUpgradeRange() {
            return (Integer)this.rangeUpgradeRange.get();
        }

        @Override
        public long getAutocraftingUpgradeEnergyUsage() {
            return (Long)this.autocraftingUpgradeUsage.get();
        }
    }

    private class WirelessGridEntryImpl
    implements Config.WirelessGridEntry {
        private final ModConfigSpec.LongValue energyCapacity;
        private final ModConfigSpec.LongValue openEnergyUsage;
        private final ModConfigSpec.LongValue extractEnergyUsage;
        private final ModConfigSpec.LongValue insertEnergyUsage;

        WirelessGridEntryImpl(ConfigImpl configImpl) {
            configImpl.builder.translation(ConfigImpl.translationKey("wirelessGrid")).push("wirelessGrid");
            this.energyCapacity = configImpl.builder.translation(ConfigImpl.translationKey("wirelessGrid.energyCapacity")).defineInRange(ConfigImpl.ENERGY_CAPACITY, 1000L, 0L, Long.MAX_VALUE);
            this.openEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("wirelessGrid.openEnergyUsage")).defineInRange(ConfigImpl.OPEN_ENERGY_USAGE, 5L, 0L, Long.MAX_VALUE);
            this.extractEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("wirelessGrid.extractEnergyUsage")).defineInRange("extractEnergyUsage", 5L, 0L, Long.MAX_VALUE);
            this.insertEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("wirelessGrid.insertEnergyUsage")).defineInRange("insertEnergyUsage", 5L, 0L, Long.MAX_VALUE);
            configImpl.builder.pop();
        }

        @Override
        public long getEnergyCapacity() {
            return (Long)this.energyCapacity.get();
        }

        @Override
        public long getOpenEnergyUsage() {
            return (Long)this.openEnergyUsage.get();
        }

        @Override
        public long getExtractEnergyUsage() {
            return (Long)this.extractEnergyUsage.get();
        }

        @Override
        public long getInsertEnergyUsage() {
            return (Long)this.insertEnergyUsage.get();
        }
    }

    private class WirelessTransmitterEntryImpl
    implements Config.WirelessTransmitterEntry {
        private final ModConfigSpec.LongValue energyUsage;
        private final ModConfigSpec.IntValue baseRange;

        WirelessTransmitterEntryImpl(ConfigImpl configImpl) {
            configImpl.builder.translation(ConfigImpl.translationKey("wirelessTransmitter")).push("wirelessTransmitter");
            this.energyUsage = configImpl.builder.translation(ConfigImpl.translationKey("wirelessTransmitter.energyUsage")).defineInRange(ConfigImpl.ENERGY_USAGE, 16L, 0L, Long.MAX_VALUE);
            this.baseRange = configImpl.builder.translation(ConfigImpl.translationKey("wirelessTransmitter.baseRange")).defineInRange("baseRange", 16, 0, Integer.MAX_VALUE);
            configImpl.builder.pop();
        }

        @Override
        public long getEnergyUsage() {
            return (Long)this.energyUsage.get();
        }

        @Override
        public int getBaseRange() {
            return (Integer)this.baseRange.get();
        }
    }

    private class PortableGridEntryImpl
    implements Config.PortableGridEntry {
        private final ModConfigSpec.LongValue energyCapacity;
        private final ModConfigSpec.LongValue openEnergyUsage;
        private final ModConfigSpec.LongValue extractEnergyUsage;
        private final ModConfigSpec.LongValue insertEnergyUsage;

        PortableGridEntryImpl(ConfigImpl configImpl) {
            configImpl.builder.translation(ConfigImpl.translationKey("portableGrid")).push("portableGrid");
            this.energyCapacity = configImpl.builder.translation(ConfigImpl.translationKey("portableGrid.energyCapacity")).defineInRange(ConfigImpl.ENERGY_CAPACITY, 1000L, 0L, Long.MAX_VALUE);
            this.openEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("portableGrid.openEnergyUsage")).defineInRange(ConfigImpl.OPEN_ENERGY_USAGE, 5L, 0L, Long.MAX_VALUE);
            this.extractEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("portableGrid.extractEnergyUsage")).defineInRange("extractEnergyUsage", 5L, 0L, Long.MAX_VALUE);
            this.insertEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("portableGrid.insertEnergyUsage")).defineInRange("insertEnergyUsage", 5L, 0L, Long.MAX_VALUE);
            configImpl.builder.pop();
        }

        @Override
        public long getEnergyCapacity() {
            return (Long)this.energyCapacity.get();
        }

        @Override
        public long getOpenEnergyUsage() {
            return (Long)this.openEnergyUsage.get();
        }

        @Override
        public long getExtractEnergyUsage() {
            return (Long)this.extractEnergyUsage.get();
        }

        @Override
        public long getInsertEnergyUsage() {
            return (Long)this.insertEnergyUsage.get();
        }
    }

    private class RelayEntryImpl
    implements Config.RelayEntry {
        private final ModConfigSpec.LongValue inputNetworkEnergyUsage;
        private final ModConfigSpec.LongValue outputNetworkEnergyUsage;

        RelayEntryImpl(ConfigImpl configImpl) {
            configImpl.builder.translation(ConfigImpl.translationKey("relay")).push("relay");
            this.inputNetworkEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("relay.inputNetworkEnergyUsage")).defineInRange("inputNetworkEnergyUsage", 8L, 0L, Long.MAX_VALUE);
            this.outputNetworkEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("relay.outputNetworkEnergyUsage")).defineInRange("outputNetworkEnergyUsage", 8L, 0L, Long.MAX_VALUE);
            configImpl.builder.pop();
        }

        @Override
        public long getInputNetworkEnergyUsage() {
            return (Long)this.inputNetworkEnergyUsage.get();
        }

        @Override
        public long getOutputNetworkEnergyUsage() {
            return (Long)this.outputNetworkEnergyUsage.get();
        }
    }

    private class AutocrafterEntryImpl
    implements Config.AutocrafterEntry {
        private final ModConfigSpec.LongValue energyUsage;
        private final ModConfigSpec.LongValue energyUsagePerPattern;

        AutocrafterEntryImpl(ConfigImpl configImpl) {
            configImpl.builder.translation(ConfigImpl.translationKey("autocrafter")).push("autocrafter");
            this.energyUsage = configImpl.builder.translation(ConfigImpl.translationKey("autocrafter.energyUsage")).defineInRange(ConfigImpl.ENERGY_USAGE, 4L, 0L, Long.MAX_VALUE);
            this.energyUsagePerPattern = configImpl.builder.translation(ConfigImpl.translationKey("autocrafter.energyUsagePerPattern")).defineInRange("energyUsagePerPattern", 2L, 0L, Long.MAX_VALUE);
            configImpl.builder.pop();
        }

        @Override
        public long getEnergyUsagePerPattern() {
            return (Long)this.energyUsagePerPattern.get();
        }

        @Override
        public long getEnergyUsage() {
            return (Long)this.energyUsage.get();
        }
    }

    private class AutocrafterManagerEntryImpl
    implements Config.AutocrafterManagerEntry {
        private final ModConfigSpec.LongValue energyUsage;
        private final ModConfigSpec.EnumValue<AutocrafterManagerSearchMode> searchMode;
        private final ModConfigSpec.EnumValue<AutocrafterManagerViewType> viewType;

        AutocrafterManagerEntryImpl() {
            ConfigImpl.this.builder.translation(ConfigImpl.translationKey("autocrafterManager")).push("autocrafterManager");
            this.energyUsage = ConfigImpl.this.builder.translation(ConfigImpl.translationKey("autocrafterManager.energyUsage")).defineInRange(ConfigImpl.ENERGY_USAGE, 16L, 0L, Long.MAX_VALUE);
            this.searchMode = ConfigImpl.this.builder.translation(ConfigImpl.translationKey("autocrafterManager.searchMode")).defineEnum("searchMode", (Enum)AutocrafterManagerSearchMode.ALL);
            this.viewType = ConfigImpl.this.builder.translation(ConfigImpl.translationKey("autocrafterManager.viewType")).defineEnum("viewType", (Enum)AutocrafterManagerViewType.VISIBLE);
            ConfigImpl.this.builder.pop();
        }

        @Override
        public void setSearchMode(AutocrafterManagerSearchMode searchMode) {
            if (searchMode != this.searchMode.get()) {
                this.searchMode.set((Object)searchMode);
                ConfigImpl.this.spec.save();
            }
        }

        @Override
        public AutocrafterManagerSearchMode getSearchMode() {
            return (AutocrafterManagerSearchMode)((Object)this.searchMode.get());
        }

        @Override
        public void setViewType(AutocrafterManagerViewType viewType) {
            if (viewType != this.viewType.get()) {
                this.viewType.set((Object)viewType);
                ConfigImpl.this.spec.save();
            }
        }

        @Override
        public AutocrafterManagerViewType getViewType() {
            return (AutocrafterManagerViewType)((Object)this.viewType.get());
        }

        @Override
        public long getEnergyUsage() {
            return (Long)this.energyUsage.get();
        }
    }

    private class WirelessAutocraftingMonitorEntryImpl
    implements Config.WirelessAutocraftingMonitorEntry {
        private final ModConfigSpec.LongValue energyCapacity;
        private final ModConfigSpec.LongValue openEnergyUsage;
        private final ModConfigSpec.LongValue cancelEnergyUsage;
        private final ModConfigSpec.LongValue cancelAllEnergyUsage;

        WirelessAutocraftingMonitorEntryImpl(ConfigImpl configImpl) {
            configImpl.builder.translation(ConfigImpl.translationKey("wirelessAutocraftingMonitor")).push("wirelessAutocraftingMonitor");
            this.energyCapacity = configImpl.builder.translation(ConfigImpl.translationKey("wirelessAutocraftingMonitor.energyCapacity")).defineInRange(ConfigImpl.ENERGY_CAPACITY, 1000L, 0L, Long.MAX_VALUE);
            this.openEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("wirelessAutocraftingMonitor.openEnergyUsage")).defineInRange(ConfigImpl.OPEN_ENERGY_USAGE, 5L, 0L, Long.MAX_VALUE);
            this.cancelEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("wirelessAutocraftingMonitor.cancelEnergyUsage")).defineInRange("cancelEnergyUsage", 5L, 0L, Long.MAX_VALUE);
            this.cancelAllEnergyUsage = configImpl.builder.translation(ConfigImpl.translationKey("wirelessAutocraftingMonitor.cancelAllEnergyUsage")).defineInRange("cancelAllEnergyUsage", 5L, 0L, Long.MAX_VALUE);
            configImpl.builder.pop();
        }

        @Override
        public long getEnergyCapacity() {
            return (Long)this.energyCapacity.get();
        }

        @Override
        public long getOpenEnergyUsage() {
            return (Long)this.openEnergyUsage.get();
        }

        @Override
        public long getCancelEnergyUsage() {
            return (Long)this.cancelEnergyUsage.get();
        }

        @Override
        public long getCancelAllEnergyUsage() {
            return (Long)this.cancelAllEnergyUsage.get();
        }
    }
}

