/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.slotreference;

import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReferenceFactory;
import com.refinedmods.refinedstorage.common.support.slotreference.InventorySlotReferenceFactory;
import java.util.Optional;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public final class InventorySlotReference
implements SlotReference {
    final int slotIndex;

    InventorySlotReference(int slotIndex) {
        this.slotIndex = slotIndex;
    }

    @Override
    public Optional<ItemStack> resolve(Player player) {
        ItemStack item = player.getInventory().getItem(this.slotIndex);
        if (item.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(item);
    }

    @Override
    public SlotReferenceFactory getFactory() {
        return InventorySlotReferenceFactory.INSTANCE;
    }

    @Override
    public boolean isDisabledSlot(int playerSlotIndex) {
        return playerSlotIndex == this.slotIndex;
    }

    public static SlotReference of(Player player, InteractionHand hand) {
        return new InventorySlotReference(hand == InteractionHand.MAIN_HAND ? player.getInventory().selected : 40);
    }
}

