/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.resource.list;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.AbstractProxyMutableResourceList;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import com.refinedmods.refinedstorage.common.api.support.resource.FuzzyModeNormalizer;
import com.refinedmods.refinedstorage.common.api.support.resource.list.FuzzyResourceList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class FuzzyResourceListImpl
extends AbstractProxyMutableResourceList
implements FuzzyResourceList {
    private final Map<ResourceKey, Set<ResourceKey>> normalizedFuzzyMap = new HashMap<ResourceKey, Set<ResourceKey>>();

    public FuzzyResourceListImpl(MutableResourceList delegate) {
        super(delegate);
    }

    @Override
    public MutableResourceList.OperationResult add(ResourceKey resource, long amount) {
        MutableResourceList.OperationResult result = super.add(resource, amount);
        this.addToIndex(resource, result);
        return result;
    }

    private void addToIndex(ResourceKey resource, MutableResourceList.OperationResult result) {
        if (resource instanceof FuzzyModeNormalizer) {
            FuzzyModeNormalizer normalizer = (FuzzyModeNormalizer)((Object)resource);
            this.normalizedFuzzyMap.computeIfAbsent(normalizer.normalize(), k -> new HashSet()).add(result.resource());
        }
    }

    @Override
    @Nullable
    public MutableResourceList.OperationResult remove(ResourceKey resource, long amount) {
        MutableResourceList.OperationResult result = super.remove(resource, amount);
        if (result != null && !result.available()) {
            this.removeFromIndex(resource, result);
        }
        return result;
    }

    private void removeFromIndex(ResourceKey resource, MutableResourceList.OperationResult result) {
        if (!(resource instanceof FuzzyModeNormalizer)) {
            return;
        }
        FuzzyModeNormalizer normalizer = (FuzzyModeNormalizer)((Object)resource);
        ResourceKey normalized = normalizer.normalize();
        Collection index = this.normalizedFuzzyMap.get(normalized);
        if (index == null) {
            return;
        }
        index.remove(result.resource());
        if (index.isEmpty()) {
            this.normalizedFuzzyMap.remove(normalized);
        }
    }

    @Override
    public Collection<ResourceKey> getFuzzy(ResourceKey resource) {
        if (resource instanceof FuzzyModeNormalizer) {
            FuzzyModeNormalizer normalizer = (FuzzyModeNormalizer)((Object)resource);
            return Collections.unmodifiableCollection(this.normalizedFuzzyMap.getOrDefault(normalizer.normalize(), Collections.emptySet()));
        }
        return Collections.unmodifiableCollection(this.normalizedFuzzyMap.getOrDefault(resource, Collections.emptySet()));
    }
}

