/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.packet.c2s;

import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.network.node.grid.GridExtractMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridInsertMode;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.grid.GridScrollMode;
import com.refinedmods.refinedstorage.common.api.security.PlatformPermission;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyType;
import com.refinedmods.refinedstorage.common.support.packet.c2s.AutocrafterNameChangePacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.AutocraftingMonitorCancelAllPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.AutocraftingMonitorCancelPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.AutocraftingPreviewCancelRequestPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.AutocraftingPreviewMaxAmountRequestPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.AutocraftingPreviewRequestPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.AutocraftingRequestPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.CraftingGridClearPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.CraftingGridRecipeTransferPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.FilterSlotChangePacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.GridExtractPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.GridInsertPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.GridScrollPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.PatternGridAllowedAlternativesChangePacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.PatternGridClearPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.PatternGridCraftingRecipeTransferPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.PatternGridCreatePatternPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.PatternGridProcessingRecipeTransferPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.PatternGridSmithingTableRecipeTransferPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.PatternGridStonecutterRecipeTransferPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.PropertyChangePacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.ResourceFilterSlotChangePacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.ResourceSlotAmountChangePacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.ResourceSlotChangePacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.SecurityCardBoundPlayerPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.SecurityCardPermissionPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.SecurityCardResetPermissionPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.SingleAmountChangePacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.StorageInfoRequestPacket;
import com.refinedmods.refinedstorage.common.support.packet.c2s.UseSlotReferencedItemPacket;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.apiguardian.api.API;

public final class C2SPackets {
    private C2SPackets() {
    }

    public static void sendGridExtract(PlatformResourceKey resource, GridExtractMode mode, boolean cursor) {
        Platform.INSTANCE.sendPacketToServer(new GridExtractPacket(resource, mode, cursor));
    }

    public static void sendGridScroll(PlatformResourceKey resource, GridScrollMode mode, int slotIndex) {
        Platform.INSTANCE.sendPacketToServer(new GridScrollPacket(resource, mode, slotIndex));
    }

    public static void sendGridInsert(GridInsertMode mode, boolean tryAlternatives) {
        Platform.INSTANCE.sendPacketToServer(new GridInsertPacket(mode, tryAlternatives));
    }

    public static void sendCraftingGridClear(boolean toPlayerInventory) {
        Platform.INSTANCE.sendPacketToServer(new CraftingGridClearPacket(toPlayerInventory));
    }

    public static void sendPatternGridClear() {
        Platform.INSTANCE.sendPacketToServer(PatternGridClearPacket.INSTANCE);
    }

    public static void sendPatternGridCreatePattern() {
        Platform.INSTANCE.sendPacketToServer(PatternGridCreatePatternPacket.INSTANCE);
    }

    public static void sendCraftingGridRecipeTransfer(List<List<ItemResource>> recipe) {
        Platform.INSTANCE.sendPacketToServer(new CraftingGridRecipeTransferPacket(recipe));
    }

    public static <T> void sendPropertyChange(PropertyType<T> type, T value) {
        Platform.INSTANCE.sendPacketToServer(new PropertyChangePacket(type.id(), type.serializer().apply(value)));
    }

    public static void sendStorageInfoRequest(UUID storageId) {
        Platform.INSTANCE.sendPacketToServer(new StorageInfoRequestPacket(storageId));
    }

    public static void sendResourceSlotChange(int slotIndex, boolean tryAlternatives) {
        Platform.INSTANCE.sendPacketToServer(new ResourceSlotChangePacket(slotIndex, tryAlternatives));
    }

    @API(status=API.Status.INTERNAL)
    public static void sendFilterSlotChange(ItemStack stack, int slotIndex) {
        Platform.INSTANCE.sendPacketToServer(new FilterSlotChangePacket(slotIndex, stack));
    }

    @API(status=API.Status.INTERNAL)
    public static void sendResourceFilterSlotChange(PlatformResourceKey resource, int slotIndex) {
        Platform.INSTANCE.sendPacketToServer(new ResourceFilterSlotChangePacket(slotIndex, resource));
    }

    public static void sendResourceSlotAmountChange(int slotIndex, long amount) {
        Platform.INSTANCE.sendPacketToServer(new ResourceSlotAmountChangePacket(slotIndex, amount));
    }

    public static void sendSingleAmountChange(double amount) {
        Platform.INSTANCE.sendPacketToServer(new SingleAmountChangePacket(amount));
    }

    public static void sendUseSlotReferencedItem(SlotReference slotReference) {
        Platform.INSTANCE.sendPacketToServer(new UseSlotReferencedItemPacket(slotReference));
    }

    public static void sendSecurityCardPermission(PlatformPermission permission, boolean allowed) {
        Platform.INSTANCE.sendPacketToServer(new SecurityCardPermissionPacket(permission, allowed));
    }

    public static void sendSecurityCardResetPermission(PlatformPermission permission) {
        Platform.INSTANCE.sendPacketToServer(new SecurityCardResetPermissionPacket(permission));
    }

    public static void sendSecurityCardBoundPlayer(UUID playerId) {
        Platform.INSTANCE.sendPacketToServer(new SecurityCardBoundPlayerPacket(playerId));
    }

    public static void sendPatternGridAllowedAlternativesChange(int slotIndex, Set<ResourceLocation> ids) {
        Platform.INSTANCE.sendPacketToServer(new PatternGridAllowedAlternativesChangePacket(slotIndex, ids));
    }

    public static void sendPatternGridCraftingRecipeTransfer(List<List<ItemResource>> recipe) {
        Platform.INSTANCE.sendPacketToServer(new PatternGridCraftingRecipeTransferPacket(recipe));
    }

    public static void sendPatternGridProcessingRecipeTransfer(List<List<ResourceAmount>> inputs, List<List<ResourceAmount>> outputs) {
        Platform.INSTANCE.sendPacketToServer(new PatternGridProcessingRecipeTransferPacket(inputs, outputs));
    }

    public static void sendPatternGridStonecutterRecipeTransfer(ItemResource input, ItemResource selectedOutput) {
        Platform.INSTANCE.sendPacketToServer(new PatternGridStonecutterRecipeTransferPacket(input, selectedOutput));
    }

    public static void sendPatternGridSmithingTableRecipeTransfer(List<ItemResource> template, List<ItemResource> base, List<ItemResource> addition) {
        Platform.INSTANCE.sendPacketToServer(new PatternGridSmithingTableRecipeTransferPacket(template, base, addition));
    }

    public static void sendAutocrafterNameChange(String name) {
        Platform.INSTANCE.sendPacketToServer(new AutocrafterNameChangePacket(name));
    }

    public static void sendAutocraftingPreviewRequest(UUID id, PlatformResourceKey resource, long amount) {
        Platform.INSTANCE.sendPacketToServer(new AutocraftingPreviewRequestPacket(id, resource, amount));
    }

    public static void sendAutocraftingRequest(UUID id, PlatformResourceKey resource, long amount, boolean notify) {
        Platform.INSTANCE.sendPacketToServer(new AutocraftingRequestPacket(id, resource, amount, notify));
    }

    public static void sendAutocraftingPreviewCancelRequest() {
        Platform.INSTANCE.sendPacketToServer(AutocraftingPreviewCancelRequestPacket.INSTANCE);
    }

    public static void sendAutocraftingPreviewMaxAmountRequest(PlatformResourceKey resource) {
        Platform.INSTANCE.sendPacketToServer(new AutocraftingPreviewMaxAmountRequestPacket(resource));
    }

    public static void sendAutocraftingMonitorCancel(TaskId taskId) {
        Platform.INSTANCE.sendPacketToServer(new AutocraftingMonitorCancelPacket(taskId));
    }

    public static void sendAutocraftingMonitorCancelAll() {
        Platform.INSTANCE.sendPacketToServer(AutocraftingMonitorCancelAllPacket.INSTANCE);
    }
}

