/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.packet.c2s;

import com.refinedmods.refinedstorage.api.autocrafting.preview.PreviewProvider;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.autocrafting.TimeoutableCancellationToken;
import com.refinedmods.refinedstorage.common.support.packet.PacketContext;
import com.refinedmods.refinedstorage.common.support.packet.s2c.S2CPackets;
import com.refinedmods.refinedstorage.common.support.resource.ResourceCodecs;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;

public record AutocraftingPreviewRequestPacket(UUID id, PlatformResourceKey resource, long amount) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<AutocraftingPreviewRequestPacket> PACKET_TYPE = new CustomPacketPayload.Type(IdentifierUtil.createIdentifier("autocrafting_preview_request"));
    public static final StreamCodec<RegistryFriendlyByteBuf, AutocraftingPreviewRequestPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, AutocraftingPreviewRequestPacket::id, ResourceCodecs.STREAM_CODEC, AutocraftingPreviewRequestPacket::resource, (StreamCodec)ByteBufCodecs.VAR_LONG, AutocraftingPreviewRequestPacket::amount, AutocraftingPreviewRequestPacket::new);

    public static void handle(AutocraftingPreviewRequestPacket packet, PacketContext ctx) {
        AbstractContainerMenu abstractContainerMenu = ctx.getPlayer().containerMenu;
        if (abstractContainerMenu instanceof PreviewProvider) {
            PreviewProvider provider = (PreviewProvider)abstractContainerMenu;
            ServerPlayer player = (ServerPlayer)ctx.getPlayer();
            provider.getPreview(packet.resource(), packet.amount(), new TimeoutableCancellationToken()).thenAccept(optionalPreview -> optionalPreview.ifPresent(preview -> S2CPackets.sendAutocraftingPreviewResponse(player, packet.id, preview)));
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_TYPE;
    }
}

