/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.network.item;

import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.api.support.network.item.NetworkItemContext;
import com.refinedmods.refinedstorage.common.api.support.network.item.NetworkItemHelper;
import com.refinedmods.refinedstorage.common.api.support.network.item.NetworkItemTargetBlockEntity;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.support.network.item.NetworkItemContextImpl;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntity;

public class NetworkItemHelperImpl
implements NetworkItemHelper {
    private static final MutableComponent UNBOUND = IdentifierUtil.createTranslation("item", "network_item.unbound").withStyle(ChatFormatting.RED);
    private static final Component UNBOUND_HELP = IdentifierUtil.createTranslation("item", "network_item.unbound.help");

    @Override
    public boolean isBound(ItemStack stack) {
        return stack.has(DataComponents.INSTANCE.getNetworkLocation());
    }

    @Override
    public void addTooltip(ItemStack stack, List<Component> lines) {
        this.getNetworkLocation(stack).ifPresentOrElse(network -> lines.add((Component)IdentifierUtil.createTranslation("item", "network_item.bound_to", network.pos().getX(), network.pos().getY(), network.pos().getZ()).withStyle(ChatFormatting.GRAY)), () -> lines.add((Component)UNBOUND));
    }

    @Override
    public InteractionResult bind(UseOnContext ctx) {
        if (ctx.getPlayer() == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = ctx.getPlayer().getItemInHand(ctx.getHand());
        BlockEntity blockEntity = ctx.getLevel().getBlockEntity(ctx.getClickedPos());
        if (!(blockEntity instanceof NetworkItemTargetBlockEntity)) {
            return InteractionResult.PASS;
        }
        GlobalPos pos = GlobalPos.of((ResourceKey)ctx.getLevel().dimension(), (BlockPos)blockEntity.getBlockPos());
        stack.set(DataComponents.INSTANCE.getNetworkLocation(), (Object)pos);
        return InteractionResult.SUCCESS;
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (this.isBound(stack)) {
            return Optional.empty();
        }
        return Optional.of(new HelpTooltipComponent(UNBOUND_HELP));
    }

    @Override
    public NetworkItemContext createContext(ItemStack stack, ServerPlayer player, SlotReference slotReference) {
        Optional<GlobalPos> location = this.getNetworkLocation(stack);
        return new NetworkItemContextImpl((Player)player, slotReference, location.orElse(null));
    }

    private Optional<GlobalPos> getNetworkLocation(ItemStack stack) {
        return Optional.ofNullable((GlobalPos)stack.get(DataComponents.INSTANCE.getNetworkLocation()));
    }
}

