/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.network;

import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.energy.EnergyNetworkComponent;
import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.configurationcard.ConfigurationCardTarget;
import com.refinedmods.refinedstorage.common.api.support.network.AbstractNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.api.support.network.item.NetworkItemTargetBlockEntity;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.PlayerAwareBlockEntity;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.RedstoneModeSettings;
import com.refinedmods.refinedstorage.common.support.network.ColoredConnectionStrategy;
import com.refinedmods.refinedstorage.common.support.network.NetworkNodeTicker;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseNetworkNodeContainerBlockEntity<T extends AbstractNetworkNode>
extends AbstractNetworkNodeContainerBlockEntity<T>
implements NetworkItemTargetBlockEntity,
ConfigurationCardTarget,
PlayerAwareBlockEntity,
Nameable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBaseNetworkNodeContainerBlockEntity.class);
    private static final String TAG_CUSTOM_NAME = "CustomName";
    private static final String TAG_PLACED_BY_PLAYER_ID = "pbpid";
    private static final String TAG_REDSTONE_MODE = "rm";
    private static final int ACTIVENESS_CHANGE_TICK_RATE = 20;
    protected NetworkNodeTicker ticker = NetworkNodeTicker.IMMEDIATE;
    private int activenessChangeTicks;
    @Nullable
    private Component customName;
    @Nullable
    private UUID placedByPlayerId;
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;

    protected AbstractBaseNetworkNodeContainerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, T networkNode) {
        super(type, pos, state, networkNode);
    }

    @Override
    protected InWorldNetworkNodeContainer createMainContainer(T networkNode) {
        return RefinedStorageApi.INSTANCE.createNetworkNodeContainer(this, (NetworkNode)networkNode).connectionStrategy(new ColoredConnectionStrategy(() -> ((AbstractBaseNetworkNodeContainerBlockEntity)this).getBlockState(), this.getBlockPos())).build();
    }

    protected boolean calculateActive() {
        boolean hasLevel;
        long energyUsage = ((AbstractNetworkNode)this.mainNetworkNode).getEnergyUsage();
        boolean bl = hasLevel = this.level != null && this.level.isLoaded(this.worldPosition);
        boolean redstoneModeActive = !this.hasRedstoneMode() || this.redstoneMode.isActive(hasLevel && this.level.hasNeighborSignal(this.worldPosition));
        return hasLevel && redstoneModeActive && ((AbstractNetworkNode)this.mainNetworkNode).getNetwork() != null && ((AbstractNetworkNode)this.mainNetworkNode).getNetwork().getComponent(EnergyNetworkComponent.class).getStored() >= energyUsage;
    }

    public void updateActiveness(BlockState state, @Nullable BooleanProperty activenessProperty) {
        boolean activenessNeedsUpdate;
        boolean newActive = this.calculateActive();
        boolean nodeActivenessNeedsUpdate = newActive != ((AbstractNetworkNode)this.mainNetworkNode).isActive();
        boolean blockStateActivenessNeedsUpdate = activenessProperty != null && (Boolean)state.getValue((Property)activenessProperty) != newActive;
        boolean bl = activenessNeedsUpdate = nodeActivenessNeedsUpdate || blockStateActivenessNeedsUpdate;
        if (activenessNeedsUpdate && this.activenessChangeTicks++ % 20 == 0) {
            if (nodeActivenessNeedsUpdate) {
                this.activenessChanged(newActive);
            }
            if (blockStateActivenessNeedsUpdate) {
                this.updateActivenessBlockState(state, activenessProperty, newActive);
            }
        }
    }

    protected void activenessChanged(boolean newActive) {
        LOGGER.debug("Activeness change for node at {}: {} -> {}", new Object[]{this.getBlockPos(), ((AbstractNetworkNode)this.mainNetworkNode).isActive(), newActive});
        ((AbstractNetworkNode)this.mainNetworkNode).setActive(newActive);
    }

    private void updateActivenessBlockState(BlockState state, BooleanProperty activenessProperty, boolean active) {
        if (this.level != null) {
            LOGGER.debug("Sending block update at {} due to activeness change: {} -> {}", new Object[]{this.getBlockPos(), state.getValue((Property)activenessProperty), active});
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)state.setValue((Property)activenessProperty, (Comparable)Boolean.valueOf(active)));
        }
    }

    public void doWork() {
        this.ticker.tick((AbstractNetworkNode)this.mainNetworkNode);
    }

    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(BlockState oldBlockState, BlockState newBlockState) {
        return false;
    }

    public void setBlockState(BlockState newBlockState) {
        BlockState oldBlockState = this.getBlockState();
        super.setBlockState(newBlockState);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.initialize(serverLevel);
        }
        if (this.doesBlockStateChangeWarrantNetworkNodeUpdate(oldBlockState, newBlockState)) {
            this.containers.update(this.level);
        }
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.initialize(serverLevel);
        }
    }

    protected final void initialize(ServerLevel level) {
        Direction direction = AbstractDirectionalBlock.tryExtractDirection(this.getBlockState());
        if (direction == null) {
            return;
        }
        this.initialize(level, direction);
    }

    protected void initialize(ServerLevel level, Direction direction) {
    }

    @Override
    @Nullable
    public Network getNetworkForItem() {
        return ((AbstractNetworkNode)this.mainNetworkNode).getNetwork();
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.placedByPlayerId != null) {
            tag.putUUID(TAG_PLACED_BY_PLAYER_ID, this.placedByPlayerId);
        }
        this.writeConfiguration(tag, provider);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.hasUUID(TAG_PLACED_BY_PLAYER_ID)) {
            this.setPlacedBy(tag.getUUID(TAG_PLACED_BY_PLAYER_ID));
        }
        this.readConfiguration(tag, provider);
    }

    @Override
    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        if (this.customName != null) {
            tag.putString(TAG_CUSTOM_NAME, Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)provider));
        }
        if (this.hasRedstoneMode()) {
            tag.putInt(TAG_REDSTONE_MODE, RedstoneModeSettings.getRedstoneMode(this.redstoneMode));
        }
    }

    @Override
    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains(TAG_CUSTOM_NAME, 8)) {
            this.customName = AbstractBaseNetworkNodeContainerBlockEntity.parseCustomNameSafe((String)tag.getString(TAG_CUSTOM_NAME), (HolderLookup.Provider)provider);
        }
        if (this.hasRedstoneMode() && tag.contains(TAG_REDSTONE_MODE)) {
            this.redstoneMode = RedstoneModeSettings.getRedstoneMode(tag.getInt(TAG_REDSTONE_MODE));
        }
    }

    protected boolean hasRedstoneMode() {
        return true;
    }

    private void verifyHasRedstoneMode() {
        if (!this.hasRedstoneMode()) {
            throw new IllegalStateException("Block has no redstone mode!");
        }
    }

    public RedstoneMode getRedstoneMode() {
        this.verifyHasRedstoneMode();
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode redstoneMode) {
        this.verifyHasRedstoneMode();
        this.redstoneMode = redstoneMode;
        this.setChanged();
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.customName = (Component)componentInput.get(DataComponents.CUSTOM_NAME);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.CUSTOM_NAME, (Object)this.customName);
    }

    protected final void setCustomName(@Nullable Component customName) {
        this.customName = customName;
    }

    @Nullable
    public final Component getCustomName() {
        return this.customName;
    }

    protected final Component overrideName(Component defaultName) {
        return this.customName == null ? defaultName : this.customName;
    }

    public final Component getDisplayName() {
        return this.getName();
    }

    @Override
    public void setPlacedBy(UUID playerId) {
        this.placedByPlayerId = playerId;
        this.setChanged();
    }

    protected final Player getFakePlayer(ServerLevel serverLevel) {
        return Platform.INSTANCE.getFakePlayer(serverLevel, this.placedByPlayerId);
    }

    protected final boolean isPlacedBy(UUID playerId) {
        return Objects.equals(this.placedByPlayerId, playerId);
    }
}

