/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support;

import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;

public final class ResourceSlotRendering {
    private ResourceSlotRendering() {
    }

    public static void render(GuiGraphics graphics, ResourceSlot slot, int leftPos, int topPos) {
        PlatformResourceKey resource = slot.getResource();
        if (resource == null) {
            return;
        }
        ResourceSlotRendering.render(graphics, leftPos + slot.x, topPos + slot.y, resource, slot.getAmount(), slot.shouldRenderAmount());
    }

    private static void render(GuiGraphics graphics, int x, int y, ResourceKey resource, long amount, boolean renderAmount) {
        ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(resource.getClass());
        rendering.render(resource, graphics, x, y);
        if (renderAmount) {
            ResourceSlotRendering.renderAmount(graphics, x, y, amount, rendering);
        }
    }

    public static void renderAmount(GuiGraphics graphics, int x, int y, long amount, ResourceRendering rendering) {
        ResourceSlotRendering.renderAmount(graphics, x, y, rendering.formatAmount(amount, true), 0xFFFFFF, true);
    }

    public static void renderAmount(GuiGraphics graphics, int x, int y, String text, int color, boolean large) {
        Font font = Minecraft.getInstance().font;
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((double)x + (large ? 1.0 : 0.0), (double)y + (large ? 1.0 : 0.0), 300.0);
        if (!large) {
            poseStack.scale(0.5f, 0.5f, 1.0f);
        }
        graphics.drawString(font, text, (large ? 16 : 30) - font.width(text), large ? 8 : 22, color, true);
        poseStack.popPose();
    }
}

